/* GNOME-DB
 * Copyrigth (C) 2000-2001 The Free Software Foundation
 *
 * AUTHORS:
 *      Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "gnome-db.h"
#include "gnome-db-intl.h"
#include <libgda/libgda.h>
#include <libgnomedb/gnome-db-window.h>

static void
create_window (gpointer user_data)
{
	GtkWidget *window;

	window = frontend_window_new ();
	gnome_db_window_show (GNOME_DB_WINDOW (window));
}

int
main (int argc, char *argv[])
{

#ifdef ENABLE_NLS
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, GNOMEDB_LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#endif

	/* library initialization */
	gnome_db_init ("gnome-db", VERSION, argc, argv);

	/* program initialization */
	frontend_config_init ();

	/* run program */
	gnome_db_main_run ((GdaInitFunc) create_window, NULL);

	return 0;
}
