/* GNOME DB libary
 * Copyright (C) 1999 Rodrigo Moya
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#if !defined(__gnome_db_dataset_h__)
#  define __gnome_db_dataset_h__

#include <gtk/gtkvbox.h>
#include <libgnome/gnome-defs.h>
#include <gda-recordset.h>

BEGIN_GNOME_DECLS

#define GNOME_DB_TYPE_DATASET            (gnome_db_dataset_get_type())
#define GNOME_DB_DATASET(obj)            GTK_CHECK_CAST(obj, GNOME_DB_TYPE_DATASET, GnomeDbDataset)
#define GNOME_DB_DATASET_CLASS(klass)    GTK_CHECK_CLASS_CAST(klass, GNOME_DB_TYPE_DATASET, GnomeDbDatasetClass)
#define GNOME_DB_IS_DATASET(obj)         GTK_CHECK_TYPE(obj, GNOME_DB_TYPE_DATASET)
#define GNOME_DB_IS_DATASET_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_DB_TYPE_DATASET))

typedef struct _GnomeDbDataset      GnomeDbDataset;
typedef struct _GnomeDbDatasetClass GnomeDbDatasetClass;

struct _GnomeDbDataset
{
	GtkVBox       vbox;

	/* do not use the fields in this structure! Radical changes may take place */
	GtkWidget*    frame;
	GtkWidget*    container;
	GtkWidget*    first_btn;
	GtkWidget*    previous_btn;
	GtkWidget*    next_btn;
	GtkWidget*    last_btn;
	GdaRecordset* recset;
	GList*        entries;
};

struct _GnomeDbDatasetClass
{
	GtkVBoxClass parent_class;
};

GtkType       gnome_db_dataset_get_type         (void);
GtkWidget*    gnome_db_dataset_new              (GdaRecordset *recset);

GdaRecordset* gnome_db_dataset_get_recordset    (GnomeDbDataset *dset);
void          gnome_db_dataset_set_recordset    (GnomeDbDataset *dset, GdaRecordset *recset);
void          gnome_db_dataset_set_show_buttons (GnomeDbDataset *dset, gboolean show);

END_GNOME_DECLS

#endif
