/* GNOME DB library
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#if !defined(__gnome_db_config_h__)

#include <glib.h>
#include <libgnome/gnome-defs.h>

BEGIN_GNOME_DECLS

GList* gnome_db_config_get_saved_sql_queries (void);
GList* gnome_db_config_get_saved_xml_queries (void);

typedef struct {
	gchar* name;
	gchar* location;
	gchar* description;
	gchar* repo_ids;
	gchar* type;
	gchar* icon;
} GnomeDbConfigComponent;

#define gnome_db_config_component_get_name(_com_) ((_com_) != NULL ? (_com_)->name : NULL)
#define gnome_db_config_component_get_location(_com_) ((_com_) != NULL ? (_com_)->location : NULL)
#define gnome_db_config_component_get_description(_com_) ((_com_) != NULL ? (_com_)->description : NULL)
#define gnome_db_config_component_get_repo_ids(_com_) ((_com_) != NULL ? (_com_)->repo_ids : NULL)
#define gnome_db_config_component_get_type(_com_) ((_com_) != NULL ? (_com_)->type : NULL)
#define gnome_db_config_component_get_icon(_com_) ((_com_) != NULL ? (_com_)->icon : NULL)

GnomeDbConfigComponent* gnome_db_config_component_new             (void);
void                    gnome_db_config_component_free            (GnomeDbConfigComponent *component);
void                    gnome_db_config_component_set_name        (GnomeDbConfigComponent *component, const gchar *name);
void                    gnome_db_config_component_set_location    (GnomeDbConfigComponent *component, const gchar *location);
void                    gnome_db_config_component_set_description (GnomeDbConfigComponent *component, const gchar *desc);
void                    gnome_db_config_component_set_repo_ids    (GnomeDbConfigComponent *component, const gchar *repo_ids);
void                    gnome_db_config_component_set_type        (GnomeDbConfigComponent *component, const gchar *type);
void                    gnome_db_config_component_set_icon        (GnomeDbConfigComponent *component, const gchar *icon);

GList*                  gnome_db_config_get_all_components   (void);
GList*                  gnome_db_config_get_shell_components (void);
void                    gnome_db_config_component_free_list  (GList *list);

/*
 * Configuration sections
 */
#define GNOME_DB_CONFIG_SECTION_DESIGNER          "/apps/gnome-db/Designer"
#define GNOME_DB_CONFIG_SECTION_HELP_VIEWER       "/apps/gnome-db/HelpViewer"
#define GNOME_DB_CONFIG_SECTION_HELP_VIEWER_DOCS  "/apps/gnome-db/HelpViewer/Docs"
#define GNOME_DB_CONFIG_SECTION_LAST_CONNECTIONS  "/apps/gnome-db/LastConnections"
#define GNOME_DB_CONFIG_SECTION_LAST_COMMANDS     "/apps/gnome-db/LastCommands"
#define GNOME_DB_CONFIG_SECTION_SAVED_SQL_QUERIES "/apps/gnome-db/SavedQueries/SQL"
#define GNOME_DB_CONFIG_SECTION_SAVED_XML_QUERIES "/apps/gnome-db/SavedQueries/XML"
#define GNOME_DB_CONFIG_SECTION_SAVED_BATCH_JOBS  "/apps/gnome-db/SavedBatchJobs"

#define GNOME_DB_CONFIG_KEY_SHOW_TOOLTIPS         "/apps/gnome-db/Widgets/ShowTooltips"

/*
 * Repo IDS of the GNOME-DB components
 */
#define GNOME_DB_REPO_CONTROL "IDL:GNOME/DB/Control:1.0"

#define GNOME_DB_OAFIID_BUILDER_FACTORY   "OAFIID:GNOME_DB_BuilderFactory"
#define GNOME_DB_OAFIID_COMPONENT_FACTORY "OAFIID:GNOME_DB_ComponentFactory"
#define GNOME_DB_OAFIID_MANAGER_FACTORY   "OAFIID:GNOME_DB_ManagerFactory"
#define GNOME_DB_OAFIID_MONIKER_FACTORY   "OAFIID:GNOME_DB_MonikerFactory"

#define GNOME_DB_OAFIID_BUILDER          "OAFIID:GNOME_DB_Builder_Control"
#define GNOME_DB_OAFIID_CONNECTION       "OAFIID:GNOME_DB_Connection_Control"
#define GNOME_DB_OAFIID_DESIGNER         "OAFIID:GNOME_DB_Designer_Control"
#define GNOME_DB_OAFIID_EXPORT           "OAFIID:GNOME_DB_Export_Control"
#define GNOME_DB_OAFIID_IMPORT           "OAFIID:GNOME_DB_Import_Control"
#define GNOME_DB_OAFIID_LOG_VIEWER       "OAFIID:GNOME_DB_LogViewer_Control"
#define GNOME_DB_OAFIID_MANAGER          "OAFIID:GNOME_DB_Manager_Control"
#define GNOME_DB_OAFIID_MONIKER_DATABASE "OAFIID:GNOME_DB_Moniker_Database"

END_GNOME_DECLS

#endif
