/* GNOME DB libary
 * Copyright (C) 1999 Rodrigo Moya
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __gnome_db_icon_list_h__
#define __gnome_db_icon_list_h__ 1

#include <gnome.h>
#include <gda-recordset.h>

BEGIN_GNOME_DECLS

#define GNOME_DB_TYPE_ICON_LIST            (gnome_db_icon_list_get_type())
#define GNOME_DB_ICON_LIST(obj)            GTK_CHECK_CAST(obj, GNOME_DB_TYPE_ICON_LIST, GnomeDbIconList)
#define GNOME_DB_ICON_LIST_CLASS(klass)    GTK_CHECK_CLASS_CAST(klass, GNOME_DB_TYPE_ICON_LIST, GnomeDbIconListClass)
#define GNOME_DB_IS_ICON_LIST(obj)         GTK_CHECK_TYPE(obj, GNOME_DB_TYPE_ICON_LIST)
#define GNOME_DB_IS_ICON_LIST_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_DB_TYPE_ICON_LIST))

typedef struct _GnomeDbIconList      GnomeDbIconList;
typedef struct _GnomeDbIconListClass GnomeDbIconListClass;

struct _GnomeDbIconList
{
  GtkVBox        box;
  GtkWidget*     scrolled_window;
  GtkWidget*     list;
  Gda_Recordset* recset;
  gint           pos;
  gint           total_rows;
  gint           timeout_handle;
  gchar*         pixmap_file;
  GList*         values;
};

struct _GnomeDbIconListClass
{
  GtkVBoxClass parent_class;
  
  void (*loaded)    (GnomeDbIconList *icon_list);
  void (*add_row)   (GnomeDbIconList *icon_list);
  void (*select_row)(GnomeDbIconList *icon_list);
};

guint          gnome_db_icon_list_get_type      (void);
GtkWidget*     gnome_db_icon_list_new           (Gda_Recordset *recset, gint pos);
void           gnome_db_icon_list_clear         (GnomeDbIconList *icon_list);

const gchar*   gnome_db_icon_list_get_string    (GnomeDbIconList *icon_list);
#define        gnome_db_icon_list_get_row_count(icon_list) GNOME_DB_ICON_LIST(icon_list)->total_rows)
Gda_Recordset* gnome_db_icon_list_get_recordset (GnomeDbIconList *icon_list);
void           gnome_db_icon_list_set_recordset (GnomeDbIconList *icon_list,
                                                 Gda_Recordset *recset,
                                                 gint pos);
const gchar*   gnome_db_icon_list_get_pixmap    (GnomeDbIconList *icon_list);
void           gnome_db_icon_list_set_pixmap    (GnomeDbIconList *icon_list, gchar *pixmap);

#endif
