/*  GNOME-DB Components
 *  Copyrigth (C) 2000 Rodrigo Moya
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include <gnomedb-com.h>

static Gda_ConnectionPool* connection_pool = NULL;

/*
 * Callbacks
 */
static void
cnc_error_cb (Gda_Connection *cnc, gpointer data)
{
  static GtkWidget* error_dialog = NULL;

  g_return_if_fail(IS_GDA_CONNECTION(cnc));

  if (!error_dialog)
    {
      error_dialog = gnome_db_errordlg_new(cnc, _("Error Viewer"));
    }
  gnome_db_errordlg_show_errors(GNOME_DB_ERRORDLG(error_dialog));
}

/*
 * Public functions
 */
Gda_Connection *
components_connection_open (const gchar *name, const gchar *user, const gchar *password)
{
  Gda_Connection* cnc;
  
  g_return_val_if_fail(name != NULL, NULL);
  
  if (!IS_GDA_CONNECTION_POOL(connection_pool))
    {
      connection_pool = gda_connection_pool_new();
    }
    
  /* open connection */
  cnc = gda_connection_pool_open_connection(connection_pool,
                                            name,
                                            user,
                                            password);
  if (IS_GDA_CONNECTION(cnc))
    {
      gtk_signal_connect(GTK_OBJECT(cnc),
                         "error",
                         GTK_SIGNAL_FUNC(cnc_error_cb),
                         NULL);
    }
  return (cnc);
}
