/* GNOME DB library
 * Copyright (C) 1999-2001 The Free Software Foundation
 *
 * Authors:
 *	Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __gnome_db_export_h__
#define __gnome_db_export_h__ 1

#include <gtk/gtkvbox.h>
#include <libgnome/gnome-defs.h>
#include <gda-connection-pool.h>
#include <gda-export.h>

BEGIN_GNOME_DECLS

#define GNOME_DB_TYPE_EXPORT            (gnome_db_export_get_type())
#define GNOME_DB_EXPORT(obj)            GTK_CHECK_CAST(obj, GNOME_DB_TYPE_EXPORT, GnomeDbExport)
#define GNOME_DB_EXPORT_CLASS(klass)    GTK_CHECK_CLASS_CAST(klass, GNOME_DB_TYPE_EXPORT, GnomeDbExportClass)
#define GNOME_DB_IS_EXPORT(obj)         GTK_CHECK_TYPE(obj, GNOME_DB_TYPE_EXPORT)
#define GNOME_DB_IS_EXPORT_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_DB_TYPE_EXPORT))

typedef struct _GnomeDbExportPrivate GnomeDbExportPrivate;
typedef struct _GnomeDbExport        GnomeDbExport;
typedef struct _GnomeDbExportClass   GnomeDbExportClass;

struct _GnomeDbExport {
	GtkVBox               vbox;
	GnomeDbExportPrivate *priv;
};

struct _GnomeDbExportClass {
	GtkVBoxClass parent_class;
};

GtkType            gnome_db_export_get_type (void);

GtkWidget         *gnome_db_export_new      (void);

GdaConnectionPool *gnome_db_export_get_pool (GnomeDbExport *export);
void               gnome_db_export_set_pool (GnomeDbExport *export,
					     GdaConnectionPool *pool);

END_GNOME_DECLS

#endif
