/*  GNOME-DB Components
 *  Copyrigth (C) 2000 Rodrigo Moya
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#if !defined(__gnomedb_com_h__)
#  define __gnomedb_com_h__

#include "config.h"
#include <gnome-db.h>
#include <libgnome/gnome-i18n.h>

BEGIN_GNOME_DECLS

/*
 * Configuration
 */
GList* components_config_get_last_commands (void);
void   components_config_add_last_command  (const gchar *cmd);

/*
 * Connection pool
 */
GdaConnection*     components_connection_open     (const gchar *name,
						   const gchar *user,
						   const gchar *password);
void               components_connection_close    (GdaConnection *cnc);
GdaConnectionPool* components_connection_get_pool (void);

/*
 * Components
 */
BonoboObject *components_connection_new       (void);
BonoboObject *components_designer_new         (void);
BonoboObject *components_export_new           (void);
BonoboObject *components_import_new           (void);
BonoboObject *components_log_new              (void);

END_GNOME_DECLS

#endif
