/* GNOME DB components libary
 * Copyright (C) 1999 Rodrigo Moya
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#if !defined(__gnome_db_control_h__)
#  define __gnome_db_control_h__

#include <gnome.h>
#include <gnome-db-control-instance.h>

BEGIN_GNOME_DECLS

#define GNOME_DB_TYPE_CONTROL            (gnome_db_control_get_type())
#define GNOME_DB_CONTROL(obj)            GTK_CHECK_CAST(obj, GNOME_DB_TYPE_CONTROL, GnomeDbControl)
#define GNOME_DB_CONTROL_CLASS(klass)    GTK_CHECK_CLASS_CAST(klass, GNOME_DB_TYPE_CONTROL, GnomeDbControlClass)
#define GNOME_DB_IS_CONTROL(obj)         GTK_CHECK_TYPE(obj, GNOME_DB_TYPE_CONTROL)
#define GNOME_DB_IS_CONTROL_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_DB_TYPE_CONTROL))

typedef GnomeDbControlInstance* (*GnomeDbControlInstanceCreateFunc)(GnomeDbControl *control);

typedef struct _GnomeDbControlPrivate GnomeDbControlPrivate;

struct _GnomeDbControl
{
  BonoboObject           object;
  GnomeDbControlPrivate* priv;
};

struct _GnomeDbControlClass
{
  BonoboObjectClass parent_class;
};

GtkType         gnome_db_control_get_type (void);
GnomeDbControl* gnome_db_control_new      (const gchar *oafiid,
                                           GnomeDbControlInstanceCreateFunc func);

END_GNOME_DECLS

#endif
