/*  GNOME-DB Monikers
 *  Copyrigth (C) 2000 Rodrigo Moya
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gnomedb-monikers.h>

static BonoboGenericFactory* database_factory = NULL;
static gint                  running_objects = 0;

/*
 * Private functions
 */
static void
database_moniker_destroy_cb (GnomeDbMoniker *moniker, gpointer data)
{
  running_objects--;
  if (running_objects > 0) return;
  
  bonobo_object_unref(BONOBO_OBJECT(database_factory));
}

static BonoboObject *
database_moniker_factory (BonoboGenericFactory *this, void *closure)
{
  GnomeDbMoniker* moniker;
  
  g_return_val_if_fail(BONOBO_IS_GENERIC_FACTORY(this), NULL);
  
  moniker = gnome_db_moniker_new("database:");
  gtk_signal_connect(GTK_OBJECT(moniker),
                     "destroy",
                     GTK_SIGNAL_FUNC(database_moniker_destroy_cb),
                     NULL);

  running_objects++;
  
  return BONOBO_OBJECT(moniker);
}

/*
 * Public functions
 */
void
monikers_database_init (void)
{
  /* create factory */
  database_factory = bonobo_generic_factory_new(GNOME_DB_OAFIID_MONIKER_DATABASE_FACTORY,
                                                database_moniker_factory,
                                                NULL);
  if (!BONOBO_IS_GENERIC_FACTORY(database_factory))
    g_error(_("Could not activate DatabaseMonikerFactory"));
}
