/* GDA Manager
 * Copyright (C) 1998,1999 Michael Lausch
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gnomedb-mgr.h"

static void
activate_dsn_tab_cb (GtkWidget *w, GnomeDbControlInstance *control_instance)
{
  GtkWidget* notebook;
  
  notebook = gnome_db_control_instance_get_widget(control_instance);
  if (GTK_IS_NOTEBOOK(notebook))
    gtk_notebook_set_page(GTK_NOTEBOOK(notebook), 0);
}

static void
activate_providers_tab_cb (GtkWidget *w, GnomeDbControlInstance *control_instance)
{
  GtkWidget* notebook;
  
  notebook = gnome_db_control_instance_get_widget(control_instance);
  if (GTK_IS_NOTEBOOK(notebook))
    gtk_notebook_set_page(GTK_NOTEBOOK(notebook), 1);
}

GnomeUIInfo optionsmenu[] =
{
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Data Sources"), N_("Manage connection data sources"),
    activate_dsn_tab_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_MAIL, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Providers"), N_("Manage available GDA providers"),
    activate_providers_tab_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_CONVERT, 0, 0, NULL },
  GNOMEUIINFO_END
};
static GnomeUIInfo manager_control_menu[] =
{
  GNOMEUIINFO_SUBTREE(N_("Options"), optionsmenu),
  GNOMEUIINFO_END
};
static GnomeUIInfo manager_control_toolbar[] =
{
  { GNOME_APP_UI_ITEM, N_("Data Sources"), N_("Manage connection data sources"),
    activate_dsn_tab_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_MAIL, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Providers"), N_("Manage available GDA providers"),
    activate_providers_tab_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_CONVERT, 0, 0, NULL },
  GNOMEUIINFO_END
};

GnomeDbControlInstance *
manager_control_create_instance_cb (GnomeDbControl *control)
{
  GtkWidget*              notebook;
  GnomeDbControlInstance* control_instance;
  
  notebook = gnome_db_new_notebook_widget();
  gtk_notebook_set_show_tabs(GTK_NOTEBOOK(notebook), FALSE);
  gtk_notebook_popup_disable(GTK_NOTEBOOK(notebook));
  
  control_instance = gnome_db_control_instance_new(control, notebook);
  if (GNOME_DB_IS_CONTROL_INSTANCE(control_instance))
    {
      manager_dsn_init(GTK_NOTEBOOK(notebook));
      manager_providers_init(GTK_NOTEBOOK(notebook));
      
      gnome_db_control_instance_set_menubar(control_instance, manager_control_menu);
      gnome_db_control_instance_set_toolbar(control_instance, manager_control_toolbar);
    }
  return control_instance;
}

