/* GNOME DB library
 * Copyright (C) 1999 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#include "gnome-db.h"
#include <libgnomeprint/gnome-print.h>
#include <libgnomeprint/gnome-print-dialog.h>
#include <libgnomeprint/gnome-printer.h>
#include <libgnomeprint/gnome-printer-dialog.h>

static GnomePrinter* default_printer = NULL;

void
gnome_db_print_setup_dlg_cb (GtkWidget *w, gpointer data)
{
  GtkWidget *dialog = gnome_print_dialog_new(_("Setup Printer"), 0);
  gnome_dialog_set_default(GNOME_DIALOG(dialog), GNOME_PRINT_PRINT);
  if (gnome_dialog_run(GNOME_DIALOG(dialog)) == GNOME_PRINT_PRINT)
    {
      default_printer = gnome_print_dialog_get_printer(GNOME_PRINT_DIALOG(dialog));
    }
  gnome_dialog_close(GNOME_DIALOG(dialog));
}

GnomePrinter *
gnome_db_print_get_printer (void)
{
  if (!default_printer) gnome_db_print_setup_dlg_cb(NULL, NULL);
  return default_printer;
}