/* GNOME DB libary
 * Copyright (C) 1999 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#if !defined(__gnome_db_help_h__)
#  define __gnome_db_help_h__

#include <gnome.h>

BEGIN_GNOME_DECLS

#define GNOME_DB_TYPE_HELP            (gnome_db_help_get_type())
#define GNOME_DB_HELP(obj)            GTK_CHECK_CAST(obj, GNOME_DB_TYPE_HELP, GnomeDbHelp)
#define GNOME_DB_HELP_CLASS(klass)    GTK_CHECK_CLASS_CAST(klass, GNOME_DB_TYPE_HELP, GnomeDbHelpClass)
#define GNOME_DB_IS_HELP(obj)         GTK_CHECK_TYPE(obj, GNOME_DB_TYPE_HELP)
#define GNOME_DB_IS_HELP_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_DB_TYPE_HELP))

typedef struct _GnomeDbHelp      GnomeDbHelp;
typedef struct _GnomeDbHelpClass GnomeDbHelpClass;

struct _GnomeDbHelp
{
  GtkVBox    parent;
  GtkWidget* index_list;
  GtkWidget* html_viewer;
};

struct _GnomeDbHelpClass
{
  GtkVBoxClass parent_class;
};

GtkType    gnome_db_help_get_type   (void);
GtkWidget* gnome_db_help_new        (void);

void       gnome_db_help_show_url   (GnomeDbHelp *help, const gchar *url);
void       gnome_db_help_go_home    (GnomeDbHelp *help);
void       gnome_db_help_go_back    (GnomeDbHelp *help);
void       gnome_db_help_go_forward (GnomeDbHelp *help);

END_GNOME_DECLS

#endif