/* GNOME DB libary
 * Copyright (C) 1998,1999 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gnome-db.h"

static void gnome_db_errordlg_class_init (GnomeDbErrorDlgClass* klass);
static void gnome_db_errordlg_init       (GnomeDbErrorDlg* error);

guint
gnome_db_errordlg_get_type (void)
{
  static guint db_errordlgtype = 0;

  if (!db_errordlgtype)
    {
      GtkTypeInfo db_errordlginfo =
      {
	"GnomeDbErrorDlg",
	sizeof (GnomeDbErrorDlg),
	sizeof (GnomeDbErrorDlgClass),
	(GtkClassInitFunc)gnome_db_errordlg_class_init,
	(GtkObjectInitFunc)gnome_db_errordlg_init,
	(GtkArgSetFunc) NULL,
	(GtkArgGetFunc) NULL,
      };
      db_errordlgtype = gtk_type_unique(gnome_dialog_get_type(), &db_errordlginfo);
    }
  return db_errordlgtype;
}

static void
cb_prev_error (GtkWidget* button, gpointer data)
{
  gnome_db_error_prev(GNOME_DB_ERROR(GNOME_DB_ERRORDLG(data)->errorwidget));
}

static void
cb_next_error (GtkWidget* button, gpointer data)
{
  gnome_db_error_next(GNOME_DB_ERROR(GNOME_DB_ERRORDLG(data)->errorwidget));
}

static void
cb_dismiss_error (GtkWidget* button, gpointer data)
{
  GnomeDbErrorDlg*   dialog = GNOME_DB_ERRORDLG(data);
  gnome_dialog_close(GNOME_DIALOG(data));
  if (IS_GDA_CONNECTION(GNOME_DB_ERROR(dialog->errorwidget)->cnc))
    {
      gda_error_list_free(GNOME_DB_ERROR(dialog->errorwidget)->cnc->errors_head);
    }
  GNOME_DB_ERROR(dialog->errorwidget)->cnc->errors_head = 0;
}

static void
gnome_db_errordlg_class_init (GnomeDbErrorDlgClass* klass)
{
}
      
static void
gnome_db_errordlg_init (GnomeDbErrorDlg* error)
{
  gnome_dialog_close_hides(GNOME_DIALOG(error), TRUE);
  error->title = 0;
}

/**
 * gnome_db_errordlg_new
 * @cnc: Gda_Connection object to display errors from
 * title: title of the dialog box
 *
 * Create a new GnomeDbErrorDlg, which is a subclass of the GnomeDialog
 * widget, just acting as a container for a GnomeDbError widget
 *
 * Returns: a pointer to the new widget, or NULL on error
 */
GtkWidget*
gnome_db_errordlg_new (Gda_Connection* cnc, gchar* title)
{
  GtkWidget*    frame;
  GtkWidget*    widget;
  const gchar*  buttons[4];
  GnomeDialog*  dialog;
  
  buttons[0] = GNOME_STOCK_BUTTON_PREV;
  buttons[1] = GNOME_STOCK_BUTTON_NEXT;
  buttons[2] = GNOME_STOCK_BUTTON_OK;
  buttons[3] = 0;
  
  widget = gtk_type_new(gnome_db_errordlg_get_type());
  gnome_dialog_constructv(GNOME_DIALOG(widget),
			  title,
			  buttons);
  GNOME_DB_ERRORDLG(widget)->errorwidget = gnome_db_error_new(cnc);
  dialog = GNOME_DIALOG(widget);
  frame = gnome_db_new_frame_widget(NULL);
  gtk_box_pack_start(GTK_BOX(dialog->vbox), frame, 1, 1, 0);
  gtk_container_add(GTK_CONTAINER(frame), GNOME_DB_ERRORDLG(widget)->errorwidget);
  gtk_widget_show(GNOME_DB_ERRORDLG(widget)->errorwidget);
  
  gtk_widget_hide(widget);
  gnome_dialog_button_connect(dialog, 0, GTK_SIGNAL_FUNC(cb_prev_error), dialog);
  gnome_dialog_button_connect(dialog, 1, GTK_SIGNAL_FUNC(cb_next_error), dialog);
  gnome_dialog_button_connect(dialog, 2, GTK_SIGNAL_FUNC(cb_dismiss_error), dialog);

  if (title != 0)
    GNOME_DB_ERRORDLG(widget)->title = g_strdup(title);
  else GNOME_DB_ERRORDLG(widget)->title = 0;
  return widget;
}

/**
 * gnome_db_errordlg_show_errors
 * @dialog: the GnomeDbErrorDlg widget
 *
 * Pops up the given GnomeDbErrorDlg widget, displaying any errors that
 * may be reported for the connection being used by this widget
 */
void
gnome_db_errordlg_show_errors (GnomeDbErrorDlg* dialog)
{
  gnome_db_error_show(GNOME_DB_ERROR(dialog->errorwidget));
  gtk_widget_show(GTK_WIDGET(dialog));
}

/**
 * gnome_db_errordlg_set_title
 * @dialog: the GnomeDbErrorDlg widget
 * @title: title to be shown
 *
 * Change the title for the given GnomeDbErrorDlg widget
 */
void
gnome_db_errordlg_set_title (GnomeDbErrorDlg *dialog, gchar *title)
{
  g_return_if_fail(GNOME_DB_IS_ERRORDLG(dialog));
  g_return_if_fail(title != 0);

  if (dialog->title != 0) g_free((gpointer) dialog->title);
  dialog->title = g_strdup(title);
}
