/* GNOME DB components libary
 * Copyright (C) 1999 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gnome-db-control.h"
#include <bonobo/bonobo-generic-factory.h>

struct _GnomeDbControlPrivate
{
  BonoboGenericFactory*            generic_factory;
  GnomeDbControlInstanceCreateFunc create_func;
  GList*                           controls;
};

enum
{
  LAST_SIGNAL
};

static guint control_signals[LAST_SIGNAL] = { 0, };

/*
 * Private functions
 */
static void
control_destroyed_cb (GnomeDbControl *control)
{
  g_return_if_fail(GNOME_DB_IS_CONTROL(control));
  g_free((gpointer) control->priv);
}

static BonoboObject *
control_factory_func (BonoboGenericFactory *factory, gpointer data)
{
  BonoboControl*  bonobo_control = NULL;
  GnomeDbControl* control;
  
  g_return_val_if_fail(BONOBO_IS_GENERIC_FACTORY(factory), NULL);
  g_return_val_if_fail(GNOME_DB_IS_CONTROL(data), NULL);
  
  control = GNOME_DB_CONTROL(data);
  if (control->priv->create_func)
    {
      GnomeDbControlInstance* control_instance = control->priv->create_func(control);
      if (GNOME_DB_IS_CONTROL_INSTANCE(control_instance))
        {
          bonobo_control = gnome_db_control_instance_get_bonobo_control(control_instance);
          if (!BONOBO_IS_CONTROL(bonobo_control))
            {
              gtk_object_unref(GTK_OBJECT(control_instance));
              bonobo_control = NULL;
            }
          else
            {
              control->priv->controls = g_list_append(control->priv->controls,
                                                     (gpointer) control_instance);
            }
        }
    }
  return BONOBO_OBJECT(bonobo_control);
}

static void
gnome_db_control_class_init (GnomeDbControlClass *klass)
{
}

static void
gnome_db_control_init (GnomeDbControl *control)
{
  g_return_if_fail(GNOME_DB_CONTROL(control));
  
  control->priv = g_new0(GnomeDbControlPrivate, 1);
  
  control->priv->generic_factory = NULL;
  control->priv->create_func = NULL;
  control->priv->controls = NULL;
}

GtkType
gnome_db_control_get_type (void)
{
  static GtkType db_control_type = 0;

  if (!db_control_type)
    {
      GtkTypeInfo db_control_info =
      {
        "GnomeDbControl",
        sizeof (GnomeDbControl),
        sizeof (GnomeDbControlClass),
        (GtkClassInitFunc) gnome_db_control_class_init,
        (GtkObjectInitFunc) gnome_db_control_init,
        (GtkArgSetFunc) NULL,
        (GtkArgSetFunc) NULL
      };
      db_control_type = gtk_type_unique(bonobo_object_get_type(), &db_control_info);
    }
  return db_control_type;
}

/**
 * gnome_db_control_construct
 */
GnomeDbControl *
gnome_db_control_construct (GnomeDbControl *control,
                            const gchar *oafiid,
                            GnomeDbControlInstanceCreateFunc func)
{
  g_return_val_if_fail(GNOME_DB_IS_CONTROL(control), NULL);
  
  control->priv->create_func = func;

  gtk_signal_connect(GTK_OBJECT(control),
                     "destroy",
                     GTK_SIGNAL_FUNC(control_destroyed_cb),
                     NULL);

  /* create GenericFactory */
  control->priv->generic_factory = bonobo_generic_factory_new(oafiid, control_factory_func, control);
  if (!control->priv->generic_factory)
    {
      gtk_object_unref(GTK_OBJECT(control));
      return NULL;
    }
  return control;
}

/**
 * gnome_db_control_new
 */
GnomeDbControl *
gnome_db_control_new (const gchar *oafiid, GnomeDbControlInstanceCreateFunc func)
{
  GnomeDbControl* control;
  
  control = GNOME_DB_CONTROL(gtk_type_new(gnome_db_control_get_type()));
  return gnome_db_control_construct(control, oafiid, func);                                   
}
