#include "db_login.h"

Gda_Connection* cnc;  /* Database connection */

/*
 * The main function.
 */
int main(int argc, char* argv[]) {

  CORBA_ORB orb;
  CORBA_Environment ev;
  
  CORBA_exception_init(&ev);
  orb = gnome_CORBA_init("db_login", /* app_id */
					     "1.0",	     /* app_version */
					     &argc,
					     argv,
					     0,          /* gnorba_flags */
					     &ev);       /* CORBA environment */

  /* Use the ORB to create a new connection object. */
  cnc = gda_connection_new(orb);

  /* Try to log in. If the login fails, exit the program
   * with a message.
   */
  if ( !login_db(cnc) ) {
      fprintf(stderr, "Login failed.\n");
      return(-1);
  }

  /* Close the connection */
  gda_connection_close(cnc);

  return (0);
}

