#include "db_gui.h"

Gda_Connection* cnc;  /* Database connection */
GladeXML *xml;        /* Glade XML document */

/* 
 * Event handler for closing 
 * the main application window 
 */
gint on_app_delete_event(GtkWidget*   w,
                         GdkEventAny* e,
                         gpointer data)
{
  gtk_main_quit();
  return FALSE;
}   

/* 
 * Event handler for clicking the Execute Search
 * button.  This requeries the database and refreshes 
 * the data in the grid.
 */
gint on_execute_search_clicked(GtkWidget* execute_search) {

  GtkWidget* cmb_company; /* The company combo */
  GtkWidget* grid;        /* The grid */
  GtkObject* grs;         /* A recordset */

  gchar *company_id;       /* selected company */
  gchar sql_buffer[1024];  /* Buffer for SQL statement */
  gint rc;                 /* Return value of issuing SQL */

  /* Get the grid object and the combo object */
  grid        = glade_xml_get_widget(xml, "grid");
  cmb_company = glade_xml_get_widget(xml, "cmb_company");

  /* Get the selected ID value from the combo */
  company_id = get_selected_id(cmb_company);

  /* 
   * Create an SQL statement that fetches all rows
   * from the contact table for the selected company.
   */
  sprintf(sql_buffer, 
          "SELECT name, city FROM contact WHERE company = %s",
          company_id);

  /* Create a new recordset and query the database. */
  grs = gda_recordset_new();
  gda_recordset_set_connection(GDA_RECORDSET(grs), cnc);
  rc = gda_recordset_open_txt(GDA_RECORDSET(grs), 
                              sql_buffer, 
                              GDA_OPEN_STATIC, 
                              GDA_LOCK_PESSIMISTIC, 
                              0);
  if (rc < 0) {
    fprintf(stderr, "Could not issue query.\n");
    gtk_main_quit();
  }

  /* Update the grid with the new recordset */
  gnome_db_grid_set_recordset(GNOME_DB_GRID(grid), 
                              GDA_RECORDSET(grs));
  gtk_widget_show(grid);

}

/* 
 * Create a combo dialog for the company table
 */
GtkWidget* get_company_combo() {
  return create_gda_combo(cnc, "company", "name", "id");
}

/*
 * Create a grid object with an empty result set.
 */
GtkWidget* get_grid() {

  GtkObject* grs;
  gint rc;

  /* Create an empty recordset (where 6 = 9) */
  grs = gda_recordset_new();
  gda_recordset_set_connection(GDA_RECORDSET(grs), cnc);
  rc = gda_recordset_open_txt(GDA_RECORDSET(grs), 
                              "SELECT * FROM contacts "
                              "WHERE 1 = 0", 
                              GDA_OPEN_STATIC, 
                              GDA_LOCK_PESSIMISTIC, 
                              0);
  if (rc < 0) {
    fprintf(stderr, "Could not issue query.\n");
    gtk_main_quit();
  }

  /* Create a grid object with the recordset */
  return gnome_db_grid_new(GDA_RECORDSET(grs));
}

/* Close the recordset when the Grid is deleted */
gint on_grid_delete_event(GtkWidget* grid, gpointer data) {
  Gda_Recordset* grs;
  grs = gnome_db_grid_get_recordset(GNOME_DB_GRID(grid));
  gda_recordset_close(grs);
  return FALSE; 
}

/*
 * The main function.
 */
int main(int argc, char* argv[]) {

  CORBA_ORB orb;
  CORBA_Environment ev;
  
  CORBA_exception_init(&ev);
  orb = gnome_CORBA_init("db_gui", /* app_id */
					     "1.0",	     /* app_version */
					     &argc,
					     argv,
					     0,          /* gnorba_flags */
					     &ev);       /* CORBA environment */

  /* Use the ORB to create a new connection object. */
  cnc = gda_connection_new(orb);

  /* Set up an error handler for the connection */
  register_error_handler(cnc);

  /* Try to log in. If the login fails, exit the program
   * with a message.
   */
  if ( !login_db(cnc) ) {
      fprintf(stderr, "Login failed.\n");
      return(-1);
  }

  /* Initialize Glade */
  glade_gnome_init(); 
   
  /* Load the UI definition from the file */
  xml = glade_xml_new("db_gui.glade", NULL);
   
  /* Connect the signals that are defined in the file */
  glade_xml_signal_autoconnect(xml);
   
  gtk_main(); /* main loop */

  /* Close the connection */
  gda_connection_close(cnc);

  return (0);
}

