/* GNOME DB libary
 * Copyright (C) 1998,1999 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>


#include <libgnorba/gnorba.h>
#include <gda-client.h>

gchar* provider = 0;
gchar* database = 0;
gchar* username = 0;
gchar* password = 0;
gchar* table = 0;

struct poptOption options[] = {
  { "provider", 's', POPT_ARG_STRING, &provider, 0, N_("database provider"), N_("PROVIDER")},
  { "database", 'd', POPT_ARG_STRING, &database, 0, N_("database name"), N_("DATABASE")},
  { "user",     'u', POPT_ARG_STRING, &username, 0, N_("user name"), N_("USER-NAME")},
  { "password", 'p', POPT_ARG_STRING, &password, 0, N_("password"), N_("PASSWORD")},
  { "table",    't', POPT_ARG_STRING, &table,    0, N_("table"),    N_("TABLE NAME")},
  {0, 0, 0, 0, 0, 0, 0}
};



void Exception( CORBA_Environment *ev )
{
  switch( ev->_major )
    {
    case CORBA_SYSTEM_EXCEPTION:
      fprintf( stderr, "CORBA system exception %s.\n",
	       CORBA_exception_id(ev));
      exit ( 1 );
    case CORBA_USER_EXCEPTION:
      fprintf( stderr, "CORBA user exception: %s.\n",
	       CORBA_exception_id( ev ) );
      exit ( 1 );
    default:
      break;
    }
}

int
main(int argc, char* argv[])
{

  CORBA_ORB orb;
  CORBA_Environment ev;
  Gda_Connection*    cnc;
  Gda_Command*       cmd;
  Gda_Recordset*     rs;
  gulong             reccount;
  gulong             position;
  Gda_Field*         field;
  GDA_FieldValue*    value;
  gchar              bfr[128];
  gchar              vbfr[255];
  gint               fieldidx;
  gchar              cmd_bfr[1024];
  
  CORBA_exception_init(&ev);

  orb = gnome_CORBA_init_with_popt_table("gda-client-test1", /* app_id */
					 "0.1",	/* app_version */
					 &argc,
					 argv,
					 options, /* options */
					 0, /* popt_flags */
					 0, /* return_ctx */
					 0, /* gnorba_flags */
					 &ev);

  Exception(&ev);

  cnc = gda_connection_new(orb);
  gda_connection_set_provider(cnc, provider);
  if (gda_connection_open(cnc, database, username, password) < 0)
    {
      fprintf(stderr,"gda_connection_open failed\n");
      return -1;
    }
  cmd = gda_command_new();
  if (gda_command_set_connection(cmd, cnc) < 0)
    {
      fprintf(stderr,"First gda_command_set_connection() failed\n");
      return -1;
    }
  fprintf(stderr, "gda_command_set_connection successfull\n");
  g_snprintf(cmd_bfr, sizeof(cmd_bfr), "select * from %s", table);
  gda_command_set_text(cmd, cmd_bfr);
  getchar();
  rs = gda_command_execute(cmd, &reccount, 0);
  fprintf(stderr, "gda_command_execute successfull\n");
  if (!rs)
    {
      fprintf(stderr,"No recordset from gda_command_execute\n");
      return -1;
    }
  position = gda_recordset_move(rs, 1, 0);
  fprintf(stderr,"Position after move = 0x%08lx\n", position);
  if (position != GDA_RECORDSET_INVALID_POSITION)
    for (fieldidx = 0; fieldidx < gda_recordset_rowsize(rs); fieldidx++)
      {
	field = gda_recordset_field_idx(rs, fieldidx);
	fprintf(stderr,"field->name = '%s'\n", gda_field_name(field));
	fprintf(stderr,"field->gdaType    = %s[%d]\n",
		gda_fieldtype_2_string(bfr, sizeof(bfr), gda_field_type(field)), gda_field_type(field));
	fprintf(stderr,"field->cType      = %d\n", gda_field_cType(field));
	fprintf(stderr,"field->nativeType = %d\n", gda_field_nativeType(field));
	fprintf(stderr,"Value: is_null    = %d\n", gda_field_isnull(field));
	if (gda_field_isnull(field))
	  {
	    fprintf(stderr," <NULL>\n");
	    continue;
	  }
	value = field->real_value;
	fprintf(stderr,"field->actualSize = %d\n", gda_field_actual_size(field));
	fprintf(stderr,"field->scale      = %d\n", gda_field_scale(field));
	
	fprintf(stderr,"       gdatype    = %d\n", value->_u.v._d);
	fprintf(stderr,"       value      = %s\n", gda_stringify_value(vbfr,
								       sizeof(vbfr), field));
	fprintf(stderr,"\n\n");
      }
  
  gda_connection_close(cnc);
  return 0;
}

  
