/* GNOME DB Rolodex application
 * Copyright (C) 2000 Alvaro del Castillo 
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#if !defined(__rolodex_h__)
#  define __rolodex_h__

#include <config.h>
#include <gnome.h>
#include <bonobo.h>
#include <glade/glade.h>
#include <gda-ui.h>
#include <gnome-db-container.h>

#define TABLE_QULIFIER_IDX     0
#define TABLE_OWNER_IDX        1
#define TABLE_NAME_IDX         2
#define COLUMN_NAME            3
#define DATA_TYPE              4
#define TYPE_NAME              5
#define PRECISION              6
#define LENGTH                 7
#define SCALE                  8
#define RADIX                  9
#define NULLABLE               10

/* Glade */
#define ROLODEX_GLADE_FILE "gda-rolodex.glade"

/* Workarea management */
void login_db 			(Gda_Connection* cnc);
void show_data			(Gda_Connection* cnc, gchar *tablename);
void show_tables 		(Gda_Connection *cnc);

/* Callbacks */
void rolodex_error_cb		(Gda_Connection* cnc, gpointer data);
void rolodex_login_cb 		(Gda_Connection *cnc, gpointer data);
void rolodex_login_cancel_cb 	(GnomeDbLoginDlg *login_dialog, gpointer data);
void rolodex_display_errors_cb	(GtkWidget* application, GList* errors);
void rolodex_table_selected_cb 	(GtkWidget *w, gpointer data);
void rolodex_quit_cb		(GtkWidget *w, gpointer data);	
void rolodex_update_status_bar	(GtkObject* obj, gpointer data);
gint rolodex_change_record_cb	(gpointer data);

/* Control session callbacks */
void rolodex_session_die        (GnomeClient * client, gpointer client_data);
gint rolodex_save_session       (GnomeClient * client, gint phase, GnomeSaveStyle save_style,
              gint is_shutdown, GnomeInteractStyle interact_style,
              gint is_fast, gpointer client_data);


/* Global variables */
/* Defined in rolodex-main.c */
extern GtkWidget*       statusbar;
extern GtkWidget* 	glb_container;
extern GladeXML*        xml;
extern Gda_Connection*  cnc;
extern CORBA_ORB        orb;
/* Defined in rolodex-callbacks.c */
GtkWidget *menubar, *toolbar;
#endif

