/* Sample Rolodex Application
 * Copyright (C) 1998,1999 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __roloview_h__
#define __roloview_h__

#include <gtk/gtk.h>

#define ROLONAV(obj)             GTK_CHECK_CAST(obj, gda_rolodex_nav_get_type(), Rolonav)
#define ROLONAV_CLASS(klass)     GTK_CHECK_CLASS_CAST(klass, gda_rolodex_nav_get_type(), RolonavClass)
#define IS_ROLONAV(obj)          GTK_CHECK_TYPE(obj, gda_rolodex_nav_get_type())

typedef struct _Rolonav Rolonav;
typedef struct _RolonavClass RolonavClass;

struct _Rolonav
{
  GtkHBox          hbox;
  GtkWidget*       upper_half_full;
  GtkWidget*       upper_half_empty;
  GtkWidget*       glue;
  GtkWidget*       lower_half_full;
  GtkWidget*       lower_half_empty;
  
  GtkWidget*       upper_button;
  GtkWidget*       lower_button;
  GtkWidget*       upper_pixmap;
  GtkWidget*       lower_pixmap;
  GtkAdjustment*   adjustment;
};

struct _RolonavClass
{
  GtkHBoxClass parent_class;
  void (*previous) (Rolonav*);
  void (*next) (Rolonav*);
};

guint             gda_rolodex_nav_get_type    (void);


GtkWidget*        gda_rolodex_nav_new         (GtkAdjustment* adj);
void              gda_rolodex_nav_upper_status(Rolonav* nav, gboolean isempty);
void              gda_rolodex_nav_lower_status(Rolonav* nav, gboolean isempty);

#endif

  
