/* GNOME-DB
 * Copyright (c) 1998 by Rodrigo Moya
 * Copyright (c) 2000 by Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GDA_POSTGRES_RECSET_H__
#  define __GDA_POSTGRES_RECSET_H__

Gda_POSTGRES_Recordset *gda_postgres_recset_new (void);
void                    gda_postgres_recset_free (Gda_POSTGRES_Recordset *);
gint                    gda_postgres_recset_close (Gda_POSTGRES_Recordset *);
gint                    gda_postgres_recset_move_next (Gda_POSTGRES_Recordset *);
gint                    gda_postgres_recset_move_prev (Gda_POSTGRES_Recordset *);

/* debugging stuff */
void gda_postgres_recset_dump (Gda_POSTGRES_Recordset *);

/*
 * Functions to replace some data in the Recordset at loading time
 * (in static function fill_field_values())
 */

/* Function to replace some values of a recset with another */
gchar * replace_PROV_TYPES_with_gdatype(Gda_POSTGRES_Recordset *recset, 
					gchar * oid);
gchar * replace_TABLE_NAME_with_SQL(Gda_POSTGRES_Recordset *recset, 
				    gchar *table);
gchar * replace_AGGREGATE_OID_with_SQL(Gda_POSTGRES_Recordset *recset, 
				       gchar *oid);
gchar * replace_SEQUENCE_NAME_with_SQL(Gda_POSTGRES_Recordset *recset, 
				       gchar *seq);
gchar * replace_FUNCTION_OID_with_SQL(Gda_POSTGRES_Recordset *recset, 
				      gchar *fnoid);
gchar * replace_TABLE_FIELD_with_length(Gda_POSTGRES_Recordset *recset, 
					gchar *tf);
gchar * replace_TABLE_FIELD_with_defaultval(Gda_POSTGRES_Recordset *recset, 
					    gchar *tf);
gchar * replace_TABLE_FIELD_with_iskey(Gda_POSTGRES_Recordset *recset, 
				       gchar *tf);

/* utility stuff */
/* creates a GSList with each node pointing to a string which appears
   in the tabular (space separated values).
   the created list will have to be freed, as well as its strings contents.*/
GSList *convert_tabular_to_list(gchar *tab);

#endif
