/* GNOME DB MySQL Config Component
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gda-mysql-config.h>

static GtkWidget* gda_mysql_main_create_widget_cb (void);
static void       gda_mysql_main_new_instance_cb  (GnomeDbControl *control,
						   GnomeDbControlInstance *control_instance,
						   gpointer user_data);

int
main (int argc, char *argv[])
{
  CORBA_Environment ev;
  GnomeDbControl*   control;
  CORBA_ORB         orb;

  /* initialize CORBA/bonobo */
#if USING_OAF
  gnome_init("gda-mysql-config", VERSION, argc, argv);
  oaf_init(argc, argv);
  orb = oaf_orb_get();
#else
  CORBA_exception_init(&ev);
  gnome_CORBA_init("gda-mysql-config", VERSION,
		   &argc, argv,
		   GNORBA_INIT_SERVER_FUNC,
		   &ev);

  if (ev._major != CORBA_NO_EXCEPTION)
    g_error(_("Could not initialize CORBA"));

  orb = gnome_CORBA_ORB();
  CORBA_exception_free(&ev);
#endif
  if (!bonobo_init(orb, NULL, NULL))
    g_error(_("Could not initialize Bonobo"));

  /* initialize widget factory */
#if USING_OAF
  control = gnome_db_control_new("OAFIID:control-factory:gda-mysql-config:df917704-9653-400a-acae-355d6a3510c2",
#else
  control = gnome_db_control_new("control-factory:gda-mysql-config",
#endif
				 gda_mysql_main_create_widget_cb);
  gtk_signal_connect(GTK_OBJECT(control),
		     "new_instance",
		     GTK_SIGNAL_FUNC(gda_mysql_main_new_instance_cb),
		     NULL);
  if (!control)
    g_error(_("Could not create GnomeDbControl"));

  gda_mysql_db_init();

  bonobo_main();
  return 0;
}

static GtkWidget *
gda_mysql_main_create_widget_cb (void)
{
  GtkWidget* w;
  GtkWidget* db_tab;

  w = gtk_notebook_new();

  /* create tabs */
  db_tab = gda_mysql_db_create_widget_cb();
  gtk_widget_show(db_tab);
  gtk_notebook_append_page(GTK_NOTEBOOK(w), db_tab, gtk_label_new(_("Database")));

  return w;
}

static void
gda_mysql_main_new_instance_cb (GnomeDbControl *control,
				GnomeDbControlInstance *control_instance,
				gpointer user_data)
{
  g_print(_("new instance %p created"), control_instance);
}
