/* GNOME DB MySQL Config Component
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gda-mysql-config.h>

void
gda_mysql_db_init (void)
{
  GnomeDbControl* control;

  control = gnome_db_control_new("control-factory:gda-mysql-db",
				 gda_mysql_db_create_widget_cb);
  gtk_signal_connect(GTK_OBJECT(control),
		     "new_instance",
		     GTK_SIGNAL_FUNC(gda_mysql_db_new_instance_cb),
		     NULL);
  if (!control)
    g_error(_("Could not create GnomeDbControl"));
}

GtkWidget *
gda_mysql_db_create_widget_cb (void)
{
  GtkWidget* w;
  GtkWidget* frame;
  GtkWidget* scroll;
  GtkWidget* db_list;
  GtkWidget* button;
  GtkWidget* label;
  GtkWidget* entry;

  /* create main container */
  w = gtk_table_new(5, 12, FALSE);

  frame = gtk_frame_new(_("Available databases"));
  gtk_widget_show(frame);
  gtk_table_attach(GTK_TABLE(w), frame, 0, 4, 0, 8,
		   GTK_FILL | GTK_EXPAND | GTK_SHRINK,
		   GTK_FILL | GTK_EXPAND | GTK_SHRINK,
		   3, 3);
  scroll = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_show(scroll);
  db_list = gtk_list_new();
  gtk_container_add(GTK_CONTAINER(scroll), db_list);
  gtk_container_add(GTK_CONTAINER(frame), scroll);

  button = gnome_pixmap_button(gnome_stock_new_with_icon(GNOME_STOCK_MENU_NEW), _("New"));
  gtk_widget_show(button);
  gtk_table_attach(GTK_TABLE(w), button, 4, 5, 0, 1, GTK_FILL, GTK_FILL, 3, 3);
  button = gnome_pixmap_button(gnome_stock_new_with_icon(GNOME_STOCK_MENU_TRASH), _("Drop"));
  gtk_widget_show(button);
  gtk_table_attach(GTK_TABLE(w), button, 4, 5, 1, 2, GTK_FILL, GTK_FILL, 3, 3);

  /* create detail fields */
  label = gtk_label_new(_("Database name"));
  gtk_widget_show(label);
  gtk_table_attach(GTK_TABLE(w), label, 0, 1, 8, 9, GTK_FILL, GTK_FILL, 3, 3);

  label = gtk_label_new(_("Owner"));
  gtk_widget_show(label);
  gtk_table_attach(GTK_TABLE(w), label, 0, 1, 9, 10, GTK_FILL, GTK_FILL, 3, 3);

  return w;
}

void
gda_mysql_db_new_instance_cb (GnomeDbControl *control,
			      GnomeDbControlInstance *control_instance,
			      gpointer user_data)
{
}
