/* GNOME DB LDAP Config Component
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#if !defined(__gda_ldap_config_h__)
#  define __gda_ldap_config_h__

#include <gnome.h>
#if USING_OAF
#  include <liboaf/liboaf.h>
#else
#  include <libgnorba/gnorba.h>
#endif
#include <bonobo.h>
#include <gnome-db-control.h>
#include <gnome-db-control-defprops.h>

#include <config.h>

/*
 * DSN config component
 */
GtkWidget* ldap_dsn_create_widget_cb (void);
void       ldap_dsn_new_instance_cb  (GnomeDbControl *control,
				      GnomeDbControlInstance *control_instance,
				      gpointer user_data);

#endif
