/* GNOME DB Front End
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#if !defined(__gda_fe_h__)
#  define __gda_fe_h__

#include <config.h>
#include <gnome.h>
#include <bonobo.h>
#include <gda-ui.h>
#include <gnome-db-container.h>
#include <gnome-db-control-widget.h>

/* Configuration */
void   fe_config_add_command       (const gchar *cmd);
GList* fe_config_get_last_commands (void);
void   fe_config_load              (void);
void   fe_config_save              (void);

void   fe_config_open_dialog       (void);
void   fe_dsnconfig_open_dialog    (void);

/* Connections */
#define FE_CONNECTION_DATA "FE_Connection_Data"

typedef struct
{
  Gda_Connection* cnc;
  gchar*          gda_name;
  GtkWidget*      widget;

  /* SQL window */
  GtkWidget*      sql_tab;
  GtkWidget*      cmd_area;
  GtkWidget*      grid;

  /* Batch window */
  GtkWidget*      batch_tab;
  GtkWidget*      batch_cmdlist;
  GtkWidget*      batch_transmode;
  GtkWidget*      batch_sendxml;

  /* Browser window */
  GtkWidget*      browser_tab;
  GtkWidget*      browser;

  /* Export window */
  GtkWidget*      export_tab;
  GtkWidget*      export_tree;
  GtkWidget*      export_filename_entry;
  GtkWidget*      export_log;

  /* Import window */
  GtkWidget*      import_tab;
} connection_data_t;

void               fe_connection_open                 (const gchar *str, Gda_Connection *cnc);
connection_data_t* fe_connection_get_current          (void);
void               fe_connection_disconnect           (void);
void               fe_connection_show_errors          (Gda_Connection *cnc);
void               fe_connection_begin_transaction    (void);
void               fe_connection_commit_transaction   (void);
void               fe_connection_rollback_transaction (void);

void fe_connection_show_batch_window    (void);
void fe_connection_show_browser_window  (void);
void fe_connection_show_sql_window      (void);

void fe_connection_open_config          (void);
void fe_connection_view_properties      (void);

/* tools */
void fe_designer_open_window (void);
void fe_log_open_window      (void);
void fe_service_open_window  (void);

/* Work area management */
GtkWidget* fe_workarea_create          (void);
void       fe_workarea_add_tab         (const gchar *title,
					GtkWidget *w,
					GnomeUIInfo *toolbox[]);
void       fe_workarea_remove_tab      (GtkWidget *widget);
void       fe_workarea_activate_tab    (GtkWidget *widget);
GtkWidget* fe_workarea_get_current_tab (void);

/* Callbacks */
void fe_about_cb                       (GtkWidget *w, gpointer data);
void fe_open_config_cb                 (GtkWidget *w, gpointer data);
void fe_open_designer_cb               (GtkWidget *w, gpointer data);
void fe_open_dsnconfig_cb              (GtkWidget *w, gpointer data);
void fe_open_log_cb                    (GtkWidget *w, gpointer data);
void fe_open_service_manager_cb        (GtkWidget *w, gpointer data);
void fe_quit_cb                        (GnomeDbContainer *container, gpointer data);
void fe_run_app_cb                     (GtkWidget *w, const gchar *cmd);
void fe_save_config_cb                 (GtkWidget *w, gpointer data);

void fe_open_connection_cb             (GtkWidget *w, gpointer data);
void fe_close_connection_cb            (GtkWidget *w, gpointer data);
void fe_begin_transaction_cb           (GtkWidget *w, gpointer data);
void fe_commit_transaction_cb          (GtkWidget *w, gpointer data);
void fe_rollback_transaction_cb        (GtkWidget *w, gpointer data);
void fe_activate_connection_sql_cb     (GtkWidget *w, gpointer data);
void fe_activate_connection_batch_cb   (GtkWidget *w, gpointer data);
void fe_activate_connection_browser_cb (GtkWidget *w, gpointer data);
void fe_open_connection_config_cb      (GtkWidget *w, gpointer data);
void fe_view_connection_props_cb       (GtkWidget *w, gpointer data);

/* Global variables (defined in gda-fe-main.c) */
extern GtkWidget* glb_container;

#endif


