/* GNOME DB components libary
 * Copyright (C) 2000 Rodrigo Moya
 * Copyright (C) 2000 Vivien Malerba
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#if !defined(__gnome_db_control_widget_h__)
#  define __gnome_db_control_widget_h__

#include <bonobo.h>
#include <gnome-db-control-defprops.h>

BEGIN_GNOME_DECLS

#define GNOME_DB_TYPE_CONTROL_WIDGET            (gnome_db_control_widget_get_type())
#define GNOME_DB_CONTROL_WIDGET(obj)            GTK_CHECK_CAST(obj, GNOME_DB_TYPE_CONTROL_WIDGET, GnomeDbControlWidget)
#define GNOME_DB_CONTROL_WIDGET_CLASS(klass)    GTK_CHECK_CLASS_CAST(klass, GNOME_DB_TYPE_CONTROL_WIDGET, GnomeDbControlWidgetClass)
#define GNOME_DB_IS_CONTROL_WIDGET(obj)         GTK_CHECK_TYPE(obj, GNOME_DB_TYPE_CONTROL_WIDGET)
#define GNOME_DB_IS_CONTROL_WIDGET_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_DB_TYPE_CONTROL_WIDGET))

typedef struct _GnomeDbControlWidget      GnomeDbControlWidget;
typedef struct _GnomeDbControlWidgetClass GnomeDbControlWidgetClass;

struct _GnomeDbControlWidget
{
  GtkVBox                  parent;
  BonoboWidget*            bonobo_widget;
  gchar*                   goad_id;
  BonoboPropertyBagClient *prop;
};

struct _GnomeDbControlWidgetClass
{
  GtkVBoxClass parent_class;
};

GtkType    gnome_db_control_widget_get_type (void);
GtkWidget* gnome_db_control_widget_new      (const gchar *goad_id);

gboolean   gnome_db_control_widget_supported(const gchar *goad_id);
/* 
 * Functions to manipulate controls from the properties 
 */
gboolean  gnome_db_control_widget_prop_supported  (GnomeDbControlWidget *wid, 
						   const gchar *prop_name);

void gnome_db_control_widget_get_prop        (GnomeDbControlWidget *wid, 
					      const gchar *prop_name, 
					      gpointer *value);
void gnome_db_control_widget_set_prop_ptr    (GnomeDbControlWidget *wid, 
					      const gchar *prop_name, 
					      gconstpointer value);

/* give the right type of arg as the last argument */
void gnome_db_control_widget_set_prop        (GnomeDbControlWidget *wid, 
					      const gchar *prop_name, 
					      ...);
END_GNOME_DECLS

#endif
