/* GNOME DB components libary
 * Copyright (C) 2000 Rodrigo Moya
 * Copyright (C) 2000 Vivien Malerba
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gnome-db-control-widget.h>

static void gnome_db_control_widget_class_init (GnomeDbControlWidgetClass *klass);
static void gnome_db_control_widget_init       (GnomeDbControlWidget *widget);

static void gnome_db_control_widget_destroy    (GnomeDbControlWidget *widget);


/*
 * GnomeDbControlWidget object signals
 */
enum
{
  GNOME_DB_CONTROL_WIDGET_LAST_SIGNAL
};

static gint gnome_db_control_widget_signals[GNOME_DB_CONTROL_WIDGET_LAST_SIGNAL] = { 0, };

/*
 * GnomeDbControlWidget object interface
 */
static void
gnome_db_control_widget_class_init (GnomeDbControlWidgetClass *klass)
{
  GtkObjectClass* object_class = GTK_OBJECT_CLASS(klass);

  object_class->destroy = (void (*)(GtkObject *)) gnome_db_control_widget_destroy;
}

static void
gnome_db_control_widget_init (GnomeDbControlWidget *widget)
{
  g_return_if_fail(GNOME_DB_IS_CONTROL_WIDGET(widget));

  widget->bonobo_widget = NULL;
}

GtkType
gnome_db_control_widget_get_type (void)
{
  static GtkType db_control_widget_type = 0;

  if (!db_control_widget_type)
    {
      GtkTypeInfo db_control_widget_info =
      {
	"GnomeDbControlWidget",
	sizeof (GnomeDbControlWidget),
	sizeof (GnomeDbControlWidgetClass),
	(GtkClassInitFunc) gnome_db_control_widget_class_init,
	(GtkObjectInitFunc) gnome_db_control_widget_init,
	(GtkArgSetFunc) NULL,
	(GtkArgSetFunc) NULL
      };
      db_control_widget_type = gtk_type_unique(gtk_vbox_get_type(),
					       &db_control_widget_info);
    }
  return db_control_widget_type;
}

/**
 * gnome_db_control_widget_new
 */
GtkWidget *
gnome_db_control_widget_new (const gchar *id)
{
  GnomeDbControlWidget* widget;

  g_return_val_if_fail(id != NULL, NULL);

  widget = GNOME_DB_CONTROL_WIDGET(gtk_type_new(gnome_db_control_widget_get_type()));
  
  widget->goad_id = g_strdup(id);
  /* create the BonoboWidget */
  widget->bonobo_widget = BONOBO_WIDGET(bonobo_widget_new_control(id, NULL));
  if (BONOBO_IS_WIDGET(widget->bonobo_widget))
    {
      BonoboControlFrame *cf;

      gtk_widget_show(GTK_WIDGET(widget->bonobo_widget));
      gtk_box_pack_start(GTK_BOX(widget), GTK_WIDGET(widget->bonobo_widget),
			 1, 1, 0);
      /* setting the property bag here */
      cf = bonobo_widget_get_control_frame
	(BONOBO_WIDGET(widget->bonobo_widget));
      widget->prop = bonobo_control_frame_get_control_property_bag(cf);
    }
  else 
    {
      g_warning("Could not load %s", id);
      widget->bonobo_widget = NULL;
      widget->prop = NULL;
    }
  return GTK_WIDGET(widget);
}

static void
gnome_db_control_widget_destroy (GnomeDbControlWidget *widget)
{
  BonoboControlFrame* frame;

  g_return_if_fail(GNOME_DB_IS_CONTROL_WIDGET(widget));
  g_return_if_fail(BONOBO_IS_WIDGET(widget->bonobo_widget));

  g_free(widget->goad_id);
  frame = bonobo_widget_get_control_frame(BONOBO_WIDGET(widget->bonobo_widget));
  /* FIXME: is that the correct way to get rid of a bonobo control? */
  bonobo_control_frame_control_deactivate(frame);
}

gboolean   gnome_db_control_widget_supported(const gchar *goad_id)
{
  const gchar* ids[] = { "IDL:BonoboControl/gnome-db-config:1.0", NULL };
  GList *servers, *list;
  gboolean found=FALSE;

  servers = od_get_server_list(ids);
  list = servers;
  while (!found && list)
    {
      if (!strcmp(od_server_info_get_id(list->data), goad_id))
	found = TRUE;
      list = g_list_next(list);
    }
  od_server_list_free(servers);
  return found;
}

/* 
 * Functions to manipulate controls from the properties.
 */
gboolean 
gnome_db_control_widget_prop_supported(GnomeDbControlWidget *wid, 
				       const gchar *prop_name)
{
  if (bonobo_property_bag_client_get_property(wid->prop, prop_name) != 
      CORBA_OBJECT_NIL)
    return TRUE;
  else
    return FALSE;
}

void gnome_db_control_widget_set_prop_ptr        (GnomeDbControlWidget *wid, 
					      const gchar *prop_name, 
					      gconstpointer value)
{
  CORBA_TypeCode ptype;

  ptype = bonobo_property_bag_client_get_property_type(wid->prop, prop_name);
  switch (ptype->kind)
    {
    case CORBA_tk_string:
      bonobo_property_bag_client_set_value_string(wid->prop, prop_name,
						  (gchar *) value);
      break;
    case CORBA_tk_boolean:
      bonobo_property_bag_client_set_value_gboolean(wid->prop, prop_name,
						    *((gboolean*) value));
      break;
    case CORBA_tk_float:
      bonobo_property_bag_client_set_value_gfloat(wid->prop, prop_name,
						  *((gfloat *) value));
      break;
    case CORBA_tk_double:
      bonobo_property_bag_client_set_value_gdouble(wid->prop, prop_name,
						  *((gdouble *) value));
      break;
    case CORBA_tk_long:
      bonobo_property_bag_client_set_value_glong(wid->prop, prop_name,
						 *((glong *) value));
      break;
    default:
      g_warning("Unsupported type of property");
    }
}

void gnome_db_control_widget_set_prop        (GnomeDbControlWidget *wid, 
					      const gchar *prop_name, 
					      ...)
{
  CORBA_TypeCode ptype;
  va_list pa;

  gchar *mstr;
  gboolean mbool;
  gfloat mfloat;
  gdouble mdouble;
  glong mlong;

  ptype = bonobo_property_bag_client_get_property_type(wid->prop, prop_name);
  va_start(pa, prop_name);
  switch (ptype->kind)
    {
    case CORBA_tk_string:
      mstr = va_arg(pa, gchar *);
      bonobo_property_bag_client_set_value_string(wid->prop, prop_name,
						  mstr);
      break;
    case CORBA_tk_boolean:
      mbool = va_arg(pa, gboolean);
      bonobo_property_bag_client_set_value_gboolean(wid->prop, prop_name,
						    mbool);
      break;
    case CORBA_tk_float:
      mfloat = va_arg(pa, gfloat);
      bonobo_property_bag_client_set_value_gfloat(wid->prop, prop_name,
						  mfloat);
      break;
    case CORBA_tk_double:
      mdouble = va_arg(pa, gdouble);
      bonobo_property_bag_client_set_value_gdouble(wid->prop, prop_name,
						  mdouble);
      break;
    case CORBA_tk_long:
      mlong = va_arg(pa, glong);
      bonobo_property_bag_client_set_value_glong(wid->prop, prop_name,
						 mlong);
      break;
    default:
      g_warning("Unsupported type of property");
    }
  va_end(pa);
}

void gnome_db_control_widget_get_prop        (GnomeDbControlWidget *wid, 
					      const gchar *prop_name, 
					      gpointer *value)
{
  CORBA_TypeCode ptype;

  ptype = bonobo_property_bag_client_get_property_type(wid->prop, prop_name);
  switch (ptype->kind)
    {
    case CORBA_tk_string:
      *((gchar **) value) = 
	bonobo_property_bag_client_get_value_string(wid->prop, prop_name);
      break;
    case CORBA_tk_boolean:
      *((gboolean *) value) = 
	bonobo_property_bag_client_get_value_gboolean(wid->prop, prop_name);
      break;
    case CORBA_tk_float:
      *((gfloat *) value) = 
	bonobo_property_bag_client_get_value_gfloat(wid->prop, prop_name);
      break;
    case CORBA_tk_double:
      *((gdouble *) value) = 
	bonobo_property_bag_client_get_value_gdouble(wid->prop, prop_name);
      break;
    case CORBA_tk_long:
      *((glong *) value) = 
	bonobo_property_bag_client_get_value_glong(wid->prop, prop_name);
      break;
    default:
      g_warning("Unsupported type of property");
    }
}
