/* GNOME DB components provider
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gda-components.h>

#define PROP_FONT "Font"

GtkWidget *
components_grid_new_widget (void)
{
  GtkWidget* grid;

  grid = gnome_db_grid_new(NULL);
  return grid;
}

void
components_grid_new_instance_cb (GnomeDbControl *control,
				 GnomeDbControlInstance *control_instance,
				 gpointer user_data)
{
  g_return_if_fail(GNOME_DB_IS_CONTROL(control));
  g_return_if_fail(control_instance != NULL);

  /* set control instance properties */
  gnome_db_control_add_property(control_instance, PROP_FONT,
				_("Font to be used for the grid"),
				GNOME_DB_CONTROL_ARG_STRING,
				"");
}

void
components_grid_set_property_cb (GnomeDbControl *control,
				 GnomeDbControlInstance *control_instance,
				 const gchar *name,
				 gpointer user_data)
{
}













