/* GNOME DB libary
 * Copyright (C) 1998,1999 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __gda_dberrordlg_h__
#define __gda_dberrordlg_h__ 1

#include <gnome.h>
#include "gnome-db-error.h"


BEGIN_GNOME_DECLS

#define GNOME_DB_TYPE_ERRORDLG            (gnome_db_errordlg_get_type())
#define GNOME_DB_ERRORDLG(obj)            (GTK_CHECK_CAST((obj), GNOME_DB_TYPE_ERRORDLG, GnomeDbErrorDlg))
#define GNOME_DB_ERRORDLG_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GNOME_DB_TYPE_ERRORDLG, GnomeDbErrorDlgClass))
#define GNOME_DB_IS_ERRORDLG(obj)         GTK_CHECK_TYPE(obj, GNOME_DB_TYPE_ERRORDLG)
#define GNOME_DB_IS_ERRORDLG_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GNOME_DB_TYPE_ERRORDLG))

typedef struct _GnomeDbErrorDlg           GnomeDbErrorDlg;
typedef struct _GnomeDbErrorDlgClass      GnomeDbErrorDlgClass;

struct _GnomeDbErrorDlg
{
  GnomeDialog dialog;
  GtkWidget*  errorwidget;
  gchar*      title;
};

struct _GnomeDbErrorDlgClass
{
  GnomeDialogClass  parent_class;
};

guint      gnome_db_errordlg_get_type          (void);

GtkWidget* gnome_db_errordlg_new               (Gda_Connection *cnc, gchar *title);
void       gnome_db_errordlg_show_errors       (GnomeDbErrorDlg *dialog);

#define    gnome_db_errordlg_get_title(dialog) (GNOME_DB_ERRORDLG(dialog)->title)
void       gnome_db_errordlg_set_title         (GnomeDbErrorDlg *dialog, gchar *title);

END_GNOME_DECLS

#endif
