#include "table_combo.h"

/*
 * Get a value from the currently selected row.
 */
gchar* get_selected_value(GtkWidget* combo, gint column_index) {

  Gda_Recordset* grs; /* The underlying record set */
  Gda_Field* field;   /* The field whose value we need */
  gchar buffer[64];   /* A buffer to hold the return value */
  
  /* Reposition the record set on the selected row */
  grs = gnome_db_combo_get_recordset(GNOME_DB_COMBO(combo));
  gnome_db_combo_sync(GNOME_DB_COMBO(combo));

  /* retrieve the field we're interested in and return it */
  field = gda_recordset_field_idx(grs, column_index); 
  gda_stringify_value(buffer, sizeof(buffer), field);
  return g_strdup(buffer); 

}

/*
 * Return the label of the currently selected item.
 */
gchar* get_selected_label(GtkWidget* combo) {
  return get_selected_value(combo, LABEL_COLUMN);
}

/*
 * Return the id of the currently selected item.
 */
gchar* get_selected_id(GtkWidget* combo) {
  return get_selected_value(combo, ID_COLUMN);
}

/* Close the recordset when the Combo is deleted */
gint on_combo_delete_event(GtkWidget* combo, gpointer data) {
  Gda_Recordset* grs;
  grs = gnome_db_combo_get_recordset(GNOME_DB_COMBO(combo));
  gda_recordset_close(grs);
  return FALSE; 
}

/* Create and return a GDA Combo object */
GtkWidget* create_gda_combo(Gda_Connection* cnc,
                            gchar* table, 
                            gchar* label_col, 
                            gchar* id_col) 
{

  GtkObject* grs;         /* A recordset */
  gchar sql_buffer[1024]; /* The SQL command */
  gint rc;                /* Result code */
  GtkWidget* combo;       /* The combo object */
   
  /* Execute the query */
  grs = gda_recordset_new();
  gda_recordset_set_connection(GDA_RECORDSET(grs), cnc);
  sprintf(sql_buffer, "SELECT %s, %s FROM %s", 
                      label_col,
                      id_col,
                      table);
  rc = gda_recordset_open_txt(GDA_RECORDSET(grs), 
                              sql_buffer, 
                              GDA_OPEN_FWDONLY, 
                              GDA_LOCK_READONLY, 
                              0);
  if (rc < 0) {
    fprintf(stderr, "Could not execute query.\n");
    gtk_main_quit();
  }

  return gnome_db_combo_new(GDA_RECORDSET(grs), LABEL_COLUMN);
   
}

