/* GNOME DB libary
 * Copyright (C) 1998,1999 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>


#include <libgnorba/gnorba.h>
#include <gda-client.h>

gchar* provider = 0;
gchar* database = 0;
gchar* username = 0;
gchar* password = 0;


struct poptOption options[] = {
  { "provider", 's', POPT_ARG_STRING, &provider, 0, N_("database provider"), N_("PROVIDER")},
  { "database", 'd', POPT_ARG_STRING, &database, 0, N_("database name"), N_("DATABASE")},
  { "user",     'u', POPT_ARG_STRING, &username, 0, N_("user name"), N_("USER-NAME")},
  { "password", 'p', POPT_ARG_STRING, &password, 0, N_("password"), N_("PASSWORD")},
  {0, 0, 0, 0, 0, 0, 0}
};


void Exception( CORBA_Environment *ev )
{
  switch( ev->_major )
    {
    case CORBA_SYSTEM_EXCEPTION:
      fprintf( stderr, "CORBA system exception %s.\n",
	       CORBA_exception_id(ev));
      exit ( 1 );
    case CORBA_USER_EXCEPTION:
      fprintf( stderr, "CORBA user exception: %s.\n",
	       CORBA_exception_id( ev ) );
      exit ( 1 );
    default:
      break;
    }
}

int
main(int argc, char* argv[])
{

  CORBA_ORB orb;
  CORBA_Environment   ev;
  Gda_Connection*     cnc;
  Gda_Command*        cmd;
  Gda_Recordset*      rs;
  gulong              reccount;
  gint                fieldidx;
  gint                row = 0;
  Gda_Field*          field;
  static GDA_Value    item_decimal_10_2;
  static GDA_Value    item_numeric_10_2;
  static GDA_Value    item_smallint;
  static GDA_Value    item_integer;
  static GDA_Value    item_real;
  static GDA_Value    item_float;
  static GDA_Value    item_double;
  gchar               vbfr[128];
  
  CORBA_exception_init(&ev);

  orb = gnome_CORBA_init_with_popt_table("gda-client-test1", /* app_id */
					 "0.1",	/* app_version */
					 &argc,
					 argv,
					 options, /* options */
					 0, /* popt_flags */
					 0, /* return_ctx */
					 0, /* gnorba_flags */
					 &ev);
 
  Exception(&ev);

  cnc = gda_connection_new(orb);
  gda_connection_set_provider(cnc, provider);
  if (gda_connection_open(cnc, database, username, password) < 0)
    {
      fprintf(stderr,"gda_connection_open failed\n");
      return -1;
    }

  cmd = gda_command_new();

  item_decimal_10_2._d     = GDA_TypeDecimal;
  item_decimal_10_2._u.lvc = CORBA_string_dup("12345.12");
  
  item_numeric_10_2._d     = GDA_TypeNumeric;
  item_numeric_10_2._u.lvc = CORBA_string_dup("98765.43");

  item_integer._d  = GDA_TypeInteger;
  item_integer._u.i = 8;
  
  item_smallint._d = GDA_TypeSmallint;
  item_smallint._u.si = 9;

  item_real._d = GDA_TypeSingle;
  item_real._u.f = (float)5.6;

  item_float._d = GDA_TypeDouble;
  item_float._u.dp = (double)1234.9876;

  item_double._d = GDA_TypeDouble;
  item_double._u.dp = (double)6789.4321;
  
  gda_command_create_parameter(cmd, "item_decimal_10_2", GDA_PARAM_IN,
			       &item_decimal_10_2);
  gda_command_create_parameter(cmd, "item_numeric_10_2", GDA_PARAM_IN,
			       &item_numeric_10_2);
  gda_command_create_parameter(cmd, "item_smallint", GDA_PARAM_IN,
			       &item_smallint);
  gda_command_create_parameter(cmd, "item_integer", GDA_PARAM_IN,
			       &item_integer);
  gda_command_create_parameter(cmd, "item_real", GDA_PARAM_IN,
			       &item_real);
  gda_command_create_parameter(cmd, "item_float", GDA_PARAM_IN,
			       &item_float);
  gda_command_create_parameter(cmd, "item_double", GDA_PARAM_IN,
			       &item_double);
  gda_command_set_text(cmd,
		      "insert into numerics1 ("
		       "item_decimal_10_2, item_numeric_10_2, item_smallint,"
		       "item_integer, item_real, item_float, item_double"
		       ") values ( ?, ?, ?, ?, ?, ?, ?)");

  gda_command_set_connection(cmd, cnc);
  rs = gda_command_execute(cmd, &reccount, 0);
  cmd = gda_command_new();
  gda_command_set_text(cmd, "select * from numerics1");
  gda_command_set_connection(cmd, cnc);

  rs = gda_command_execute(cmd, &reccount, 0);

  fprintf(stderr,"Waiting for debugger\n");
  getchar();
  fprintf(stderr,"Continuing\n");

  printf("%s", "Position ");
  for (fieldidx = 0; fieldidx < gda_recordset_rowsize(rs); fieldidx++)
    {
      field = gda_recordset_field_idx(rs, fieldidx);
	{
	  printf("%15.15s ", field->attributes->name);
	}
    }
  printf("\n");

  
  while ((row = gda_recordset_move(rs, 1, 0)) != GDA_RECORDSET_INVALID_POSITION && !gda_recordset_eof(rs))
    {
      printf("%010d", row);
      for (fieldidx = 0; fieldidx < gda_recordset_rowsize(rs); fieldidx++)
	{
	  field = gda_recordset_field_idx(rs, fieldidx);
	  printf("%15.15s", gda_stringify_value(vbfr,sizeof(vbfr), field));
	}
      printf("\n");
      row = gda_recordset_move(rs, 1, 0);
    }


  gda_connection_close(cnc);
  return 0;
}

  
