/* GNOME-DB
 * Copyright (c) 1998 by Rodrigo Moya
 * Copyright (c) 2000 by Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GDA_POSTGRES_TYPES_H__
#  define __GDA_POSTGRES_TYPES_H__

#include <glib.h>
#include <libpq-fe.h>
#include "gda-common.h"
#include "gda.h"
#include "gda-builtin-res.h"

typedef enum {
  SQL_C_DATE,
  SQL_C_TIME,
  SQL_C_TIMESTAMP,
  SQL_C_BINARY,
  SQL_C_BIT,
  SQL_C_TINYINT,
  SQL_C_CHAR,
  SQL_C_LONG,
  SQL_C_SHORT,
  SQL_C_FLOAT,
  SQL_C_DOUBLE,
  SQL_C_SLONG,
  SQL_C_SSHORT,
  SQL_C_ULONG,
  SQL_C_USHORT,
  SQL_C_STINYINT,
  SQL_C_UTINYINT,
  SQL_C_BOOKMARK
} Gda_POSTGRES_CType;

typedef struct _Gda_POSTGRES_Types_Array
{
  gchar *postgres_type;
  gulong oid;
  GDA_ValueType gda_type;
  Gda_POSTGRES_CType c_type;
} Gda_POSTGRES_Types_Array;

typedef struct _Gda_POSTGRES_Connection
{
  gchar                    *pq_host;
  gchar                    *pq_port;
  gchar                    *pq_options;
  gchar                    *pq_tty;
  gchar                    *pq_db;
  gchar                    *pq_login;
  gchar                    *pq_pwd;
  PGconn                   *pq_conn;
  GList                    *errors;
  Gda_POSTGRES_Types_Array *types_array;
} Gda_POSTGRES_Connection;

typedef struct _Gda_POSTGRES_Command
{
  struct _Gda_POSTGRES_Connection* cnc;
  gchar*                           cmd;
  gulong                           type;
} Gda_POSTGRES_Command;

typedef struct _Gda_POSTGRES_Recordset
{
  /*  struct _Gda_POSTGRES_Command *cmd;*/
  PGresult*                     pq_data;
  Gda_Builtin_Result*           btin_res; 
  Gda_POSTGRES_Connection*      cnc;
  gint                          at_begin;
  gint                          at_end;
  gulong                        pos;
  GList*                        fields;
  GSList*                       replacements;
} Gda_POSTGRES_Recordset;


/* struct to replace values within Recordsets at fil value time */ 
typedef struct _Gda_POSTGRES_Recordset_Replacement
{
  guint colnum;
  gchar* (* trans_func) (Gda_POSTGRES_Recordset *recset, gchar *value);
  GDA_ValueType newtype;
} Gda_POSTGRES_Recordset_Replacement;

typedef struct _Gda_POSTGRES_Field
{
  gchar*           name;
  gulong           sql_type;
  gshort           c_type;
  gshort           nullable; /* used only in command.c, init_recset_fields()*/
  GDA_Value*  	   value;
  guchar           precision; /* used only in command.c, init_recset_fields()*/
  gshort           num_scale;
  glong            defined_length;
  glong            actual_length;
  gint             malloced; 
} Gda_POSTGRES_Field;

typedef struct _Gda_POSTGRES_Error
{
  gchar*         description;
  glong          number;
  gchar*         source;
  gchar*         helpfile;
  gchar*         helpctxt;
  gchar*         sqlstate;
  gchar*         native;
} Gda_POSTGRES_Error;

#endif
