/* GNOME DB
 * Copyright (C) 1999 Rodrigo Moya
 * Copyright (C) 1999 Stephan Heinze
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GDA_ORACLE_TYPES_H__
#define __GDA_ORACLE_TYPES_H__ 1

#include <glib.h>
#include <oci.h>
#include <oratypes.h>
#include <ocidfn.h>
#ifdef __STDC__
#  include <ociapr.h>
#else
#  include <ocikpr.h>
#endif

#include "gda.h"
#include "gda-common.h"

typedef struct _Gda_ORACLE_Connection
{
  OCIEnv*     henv;
  OCIError*   herr;
  OCIServer*  hserver;
  OCISvcCtx*  hservice;
  OCISession* hsession;
  GList*      errors;
  gchar*      user;
} Gda_ORACLE_Connection;

typedef struct _Gda_ORACLE_Command
{
  struct _Gda_ORACLE_Connection* cnc;
  gchar*                         cmd;
  gulong                         type;
} Gda_ORACLE_Command;

typedef struct _Gda_ORACLE_Recordset
{
  Gda_ORACLE_Connection* cnc;
  OCIStmt*               hstmt;
  sword                  stmt_type;
  gint                   at_begin;
  gint                   at_end;
  gulong                 pos;
  GList*                 fields;
} Gda_ORACLE_Recordset;

typedef struct _Gda_ORACLE_Field
{
  gchar*           name;
  ub2              sql_type;
  gshort           c_type;
  gshort           nullable;
  GDA_Value*  	   value;
  guchar           precission;
  gshort           num_scale;
  glong            defined_length;
  glong            actual_length;
  gint             malloced;
  OCIDefine*       hdef;
  gpointer         real_value;
  sb2              indicator;
} Gda_ORACLE_Field;

typedef struct _Gda_ORACLE_Error
{
  gchar*         description;
  glong          number;
  gchar*         source;
  gchar*         helpfile;
  gchar*         helpctxt;
  gchar*         sqlstate;
  gchar*         native;
} Gda_ORACLE_Error;

/*
 * Global functions
 */
extern void add_error_to_connection (Gda_ORACLE_Connection *cnc);

#endif
