/* GNOME DB Front End
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gda-fe.h"

/*
 * Private functions
 */
static void
fill_dsn_list (GtkCList *clist)
{
  GList*       dsns;
  GList*       node;
  GnomePixmap* pixmap;

  g_return_if_fail(GTK_IS_CLIST(clist));

  pixmap = gda_ui_get_pixmap(GNOME_STOCK_MENU_BOOK_RED);

  gtk_clist_freeze(clist);
  dsns = node = gda_dsn_list();
  while (node)
    {
      gchar* row[2];
      gint   row_number;

      row[0] = "";
      row[1] = GDA_DSN_GDA_NAME((Gda_Dsn *) node->data);
      row_number = gtk_clist_append(clist, row);
      if (pixmap)
	{
	  gtk_clist_set_pixmap(clist, row_number, 0,
			       GNOME_PIXMAP(pixmap)->pixmap,
			       GNOME_PIXMAP(pixmap)->mask);
	}
      node = g_list_next(node);
    }
  gtk_clist_thaw(clist);

  gda_dsn_free_list(dsns);
}

/*
 * Callbacks
 */
static void
apply_dsn_cb (GtkButton *button, GnomeDbDsnConfig *dsnconfig)
{
  g_return_if_fail(GNOME_DB_IS_DSN_CONFIG(dsnconfig));
  gnome_db_dsn_config_save(dsnconfig);
}

static void
clist_select_row_cb (GtkCList *clist,
		     gint row,
		     gint column,
		     GdkEventButton *event,
		     GnomeDbDsnConfig *dsnconfig)
{
  gchar* txt = NULL;

  g_return_if_fail(GTK_IS_CLIST(clist));
  g_return_if_fail(GNOME_DB_IS_DSN_CONFIG(dsnconfig));

  if (gtk_clist_get_text(clist, row, 1, &txt))
    {
      gnome_db_dsn_config_set_name(dsnconfig, txt);
    }
}

static void
new_dsn_cb (GtkButton *button, GnomeDbDsnConfig *dsnconfig)
{
  g_return_if_fail(GNOME_DB_IS_DSN_CONFIG(dsnconfig));
  gnome_db_dsn_config_clear(dsnconfig);
}

static void
remove_dsn_cb (GtkButton *button, GnomeDbDsnConfig *dsnconfig)
{
  g_return_if_fail(GNOME_DB_IS_DSN_CONFIG(dsnconfig));
  gnome_db_dsn_config_remove(dsnconfig);
}

/*
 * Public functions
 */
void
fe_dsnconfig_open_dialog (void)
{
  GtkWidget* dialog;
  GtkWidget* frame;
  GtkWidget* table;
  GtkWidget* scroll;
  GtkWidget* clist;
  GtkWidget* dsnconfig;
  GtkWidget* box;
  GtkWidget* button;

  /* create dialog */
  dialog = gnome_dialog_new(_("Data sources"),
			    GNOME_STOCK_BUTTON_CLOSE,
			    NULL);
  gtk_widget_set_usize(dialog, 400, 300);
  frame = gda_ui_new_frame_widget(NULL);
  gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox), frame, 1, 1, 0);

  table = gda_ui_new_table_widget(4, 2, FALSE);
  gtk_container_add(GTK_CONTAINER(frame), table);

  scroll = gda_ui_new_scrolled_window_widget();
  gtk_table_attach(GTK_TABLE(table), scroll, 0, 2, 0, 2,
		   GTK_FILL | GTK_EXPAND | GTK_SHRINK,
		   GTK_FILL | GTK_EXPAND | GTK_SHRINK,
		   3, 3);
  clist = gda_ui_new_clist_widget(NULL, 2);
  fill_dsn_list(clist);
  gtk_container_add(GTK_CONTAINER(scroll), clist);

  dsnconfig = gnome_db_dsn_config_new(NULL);
  gtk_widget_show(dsnconfig);
  gtk_table_attach(GTK_TABLE(table), dsnconfig, 2, 4, 0, 1,
		   GTK_FILL | GTK_EXPAND | GTK_SHRINK,
		   GTK_FILL | GTK_EXPAND | GTK_SHRINK,
		   3, 3);

  box = gtk_hbox_new(FALSE, 3);
  gtk_widget_show(box);
  gtk_table_attach(GTK_TABLE(table), box, 2, 4, 1, 2,
		   GTK_SHRINK, GTK_SHRINK, 3, 3);
  button = gda_ui_new_button_widget_with_pixmap(_("New"), GNOME_STOCK_MENU_NEW);
  gtk_box_pack_start(GTK_BOX(box), button, 0, 0, 0);
  gtk_signal_connect(GTK_OBJECT(button),
		     "clicked",
		     GTK_SIGNAL_FUNC(new_dsn_cb),
		     (gpointer) dsnconfig);
  button = gda_ui_new_button_widget_with_pixmap(_("Apply"), GNOME_STOCK_MENU_SAVE);
  gtk_box_pack_start(GTK_BOX(box), button, 0, 0, 0);
  gtk_signal_connect(GTK_OBJECT(button),
		     "clicked",
		     GTK_SIGNAL_FUNC(apply_dsn_cb),
		     (gpointer) dsnconfig);
  button = gda_ui_new_button_widget_with_pixmap(_("Remove"), GNOME_STOCK_MENU_TRASH);
  gtk_box_pack_start(GTK_BOX(box), button, 0, 0, 0);
  gtk_signal_connect(GTK_OBJECT(button),
		     "clicked",
		     GTK_SIGNAL_FUNC(remove_dsn_cb),
		     (gpointer) dsnconfig);
  

  gtk_signal_connect(GTK_OBJECT(clist),
		     "select-row",
		     GTK_SIGNAL_FUNC(clist_select_row_cb),
		     (gpointer) dsnconfig);

  /* and run the dialog */
  gnome_dialog_run_and_close(GNOME_DIALOG(dialog));
}


