/* GNOME DB Front End
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gda-fe.h>

static void clear_designer_cb (GtkWidget *w, gpointer data);
static void close_window_cb   (GtkWidget *w, gpointer data);
static void open_file_cb      (GtkWidget *w, gpointer data);

static GtkWidget* designer_tab = NULL;
static GtkWidget* xml_viewer = NULL;
static GnomeUIInfo designer_toolbox[] =
{
  { GNOME_APP_UI_ITEM, N_("New"), N_("New database design"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_NEW, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Open"), N_("Open database design"),
    open_file_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_OPEN, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Save"), N_("Save database design"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_SAVE, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Clear"), N_("Clear all entries"),
    clear_designer_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_TRASH, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Close"), N_("Close designer window"),
    close_window_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_CLOSE, 0, 0, NULL },
  GNOMEUIINFO_END
};

/*
 * Callbacks
 */
static void
clear_designer_cb (GtkWidget *w, gpointer data)
{
  g_return_if_fail(GTK_IS_WIDGET(designer_tab));
  g_return_if_fail(GNOME_DB_IS_XML_VIEWER(xml_viewer));

  gnome_db_xml_viewer_clear(GNOME_DB_XML_VIEWER(xml_viewer));
}

static void
close_window_cb (GtkWidget *w, gpointer data)
{
  if (GTK_IS_WIDGET(designer_tab))
    {
      fe_workarea_remove_tab(designer_tab);
      designer_tab = NULL;
    }
}

static void
open_file_cb (GtkWidget *w, gpointer data)
{
  gchar* filename;

  g_return_if_fail(GTK_IS_WIDGET(designer_tab));
  g_return_if_fail(GNOME_DB_IS_XML_VIEWER(xml_viewer));

  filename = gda_ui_select_file(_("Select XML file"));
  if (filename)
    {
      gnome_db_xml_viewer_load_file(GNOME_DB_XML_VIEWER(xml_viewer), filename);
      g_free((gpointer) filename);
    }
}

/*
 * Public functions
 */
void
fe_designer_open_window (void)
{
  if (!designer_tab)
    {
      designer_tab = gtk_vbox_new(FALSE, 0);
      gtk_widget_show(designer_tab);

      xml_viewer = gnome_db_xml_viewer_new(NULL);
      gtk_widget_show(xml_viewer);
      gtk_box_pack_start(GTK_BOX(designer_tab), xml_viewer, 1, 1, 0);

      fe_workarea_add_tab(_("Designer"), designer_tab, designer_toolbox);
    }
  fe_workarea_activate_tab(designer_tab);
}





