/* GNOME-DB - Development Environment
 * Copyright (c) 1998 by Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#include "gda-builder.h"

#if !defined(GNOMELOCALEDIR)
#  define GNOMELOCALEDIR "/usr/locale"
#endif

static void  run_app_cb  (GtkWidget *w, const gchar *cmd);

static guint prepare_app (void);

/* global variables */
GnomeDbContainer* glb_Container = 0;
GtkWidget*        glb_Notebook = 0;
CORBA_ORB         glb_Orb;
Gda_Connection*   glb_dbconn = 0;

/* menus */
GnomeUIInfo filenewmenu[] =
{
  { GNOME_APP_UI_ITEM, N_("Screen"), N_("New screen"),
    0, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    0, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Report"), N_("New report"),
    0, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    0, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Server"), N_("New server"),
    0, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    0, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Repository"), N_("New repository"),
    0, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    0, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo fileopenmenu[] =
{
  { GNOME_APP_UI_ITEM, N_("Screen"), N_("Open existing screen"),
    0, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    0, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Report"), N_("Open existing report"),
    0, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    0, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Server"), N_("Open existing server"),
    0, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    0, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Repository"), N_("Open existing repository"),
    0, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    0, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo databasemenu[] =
{
  { GNOME_APP_UI_ITEM, N_("Connect..."), N_("Connect to database"),
    builder_database_connect, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_CONVERT, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Disconnect"), N_("Close database connection"),
    builder_database_disconnect, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_STOP, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Browse"), N_("Open database browser"),
    builder_browse_database_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_PROP, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Import objects"), N_("Import database objects into repository"),
    builder_database_import_objects, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo filemenu[] =
{
  GNOMEUIINFO_SUBTREE(N_("New"), filenewmenu),
  GNOMEUIINFO_SUBTREE(N_("Open"), fileopenmenu),
  { GNOME_APP_UI_ITEM, N_("Close"), N_("Close current window"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_CLOSE, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Close all"), N_("Close all open windows"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_CLOSE, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_PRINT_SETUP_ITEM(gda_ui_print_setup_dlg_cb, NULL),
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Quit"), N_("Exit application"),
    builder_quit_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_QUIT, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo toolsmenu[] =
{
#if defined(HAVE_BONOBO)
  { GNOME_APP_UI_ITEM, N_("GNOME-DB Front End"), N_("The GNOME-DB front end"),
    run_app_cb, "gda-fe", NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
#else
  { GNOME_APP_UI_ITEM, N_("SQL Front End"), N_("The SQL front end"),
    run_app_cb, "gdafe", NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
#endif
  { GNOME_APP_UI_ITEM, N_("GNOME-DB Manager"), N_("The GNOME-DB configuration tool"),
    run_app_cb, "gda-mgr", NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo helpmenu[] =
{
#if !defined(HAVE_BONOBO)
  GNOMEUIINFO_HELP("gnome-db"),
  GNOMEUIINFO_SEPARATOR,
#endif
  { GNOME_APP_UI_ITEM, N_("About gnome-db..."), N_("About this program"),
    builder_about_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_ABOUT, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo mainmenu[] =
{
  GNOMEUIINFO_SUBTREE(N_("File"), filemenu),
  GNOMEUIINFO_SUBTREE(N_("Database"), databasemenu),
  GNOMEUIINFO_SUBTREE(N_("Tools"), toolsmenu),
  GNOMEUIINFO_SUBTREE(N_("Help"), helpmenu),
  GNOMEUIINFO_END
};

/* toolbar */
GnomeUIInfo toolbar[] =
{
  { GNOME_APP_UI_ITEM, N_("New"), N_("New Screen/Report"),
    0, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_NEW, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Open"), N_("Open Screen/Report"),
    0, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_OPEN, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Preferences"), N_("Configure user preferences"),
    0, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_PREF, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Quit"), N_("Exit application"),
    builder_quit_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_EXIT, 0, 0, NULL },
  GNOMEUIINFO_END
};

/* CORBA exception handler */
void
Exception (CORBA_Environment *ev)
{
  switch (ev->_major)
    {
    case CORBA_SYSTEM_EXCEPTION :
      gda_ui_show_error("CORBA system exception %s", CORBA_exception_id(ev));
      exit(1);
    case CORBA_USER_EXCEPTION :
      gda_ui_show_error("CORBA user exception %s", CORBA_exception_id(ev));
      exit(1);
    default :
      break;
    }
}

gint 
main (gint argc, gchar *argv[])
{
  CORBA_Environment ev;

  /* initialize the i18n stuff */
  bindtextdomain(PACKAGE, GNOMELOCALEDIR);
  textdomain(PACKAGE);

  /* initialize CORBA/Bonobo stuff */
  CORBA_exception_init(&ev);
  glb_Orb = gnome_CORBA_init("gda-builder", VERSION, &argc, argv, 0, &ev);
  Exception(&ev);

  if (bonobo_init(glb_Orb, NULL, NULL) == FALSE)
    g_error(_("Could not initialize Bonobo\n"));

  /*
   * We can't make any CORBA calls unless we're in the main
   * loop.  So we delay creating the container here.
   */
  gtk_idle_add ((GtkFunction) prepare_app, NULL);

  bonobo_main();

  return (0);
}

/*
 * Callbacks
 */
static void
run_app_cb (GtkWidget *w, const gchar *cmd)
{
  gchar* args[1];

  g_return_if_fail(cmd != 0);

  args[0] = cmd;
  if (gnome_execute_async(NULL, 1, args) == -1)
    gda_ui_show_error(_("Unable to execute '%s'"), args[0]);
}

static guint
prepare_app (void)
{
  GtkWidget* table;

  glb_Container = gnome_db_container_new("gda-builder", mainmenu, toolbar, NULL);
  gda_ui_load_window_config("MainWindow", gnome_db_container_get_toplevel(glb_Container));
  gtk_signal_connect(GTK_OBJECT(glb_Container),
		     "close",
		     GTK_SIGNAL_FUNC(builder_quit_cb),
		     NULL);
                  
  /* set main window contents */
  table = gtk_table_new(4, 8, FALSE);
  gtk_widget_show(table);
  gnome_db_container_set_contents(glb_Container, table);

  gtk_table_attach(GTK_TABLE(table),
		   builder_project_window_open(),
		   0, 2, 0, 4,
		   GTK_FILL,
		   GTK_FILL,
		   3, 3);

  glb_Notebook = gda_ui_new_notebook_widget();
  gtk_table_attach(GTK_TABLE(table),
		   glb_Notebook,
		   2, 8, 0, 4,
		   GTK_FILL | GTK_SHRINK | GTK_EXPAND,
		   GTK_FILL | GTK_SHRINK | GTK_EXPAND,
		   3, 3);

  /* create default tabs */
  gnome_db_container_show(glb_Container);
  builder_help_window_open();

  return FALSE;
}




