/* GNOME DB components libary
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gnome-db-component.h>

static void gnome_db_component_class_init (GnomeDbComponentClass *klass);
static void gnome_db_component_init       (GnomeDbComponent *comp);

static void gnome_db_component_destroy    (GnomeDbComponent *comp);

/*
 * GnomeDbComponent object signals
 */
enum
{
  GNOME_DB_COMPONENT_LAST_SIGNAL
};

static gint gnome_db_component_signals[GNOME_DB_COMPONENT_LAST_SIGNAL] = { 0, };

/*
 * Private functions
 */
static BonoboObject *
component_factory (BonoboGenericFactory *factory, gpointer closure)
{
  /*
   * This function is called whenever the factory is asked for
   * another component
   */
}

/*
 * GnomeDbComponent object interface
 */
static void
gnome_db_component_class_init (GnomeDbComponentClass *klass)
{
  GtkObjectClass* object_class = (GtkObjectClass *) klass;

  object_class->destroy = gnome_db_component_destroy;
}

static void
gnome_db_component_init (GnomeDbComponent *comp)
{
  g_return_if_fail(GNOME_DB_IS_COMPONENT(comp));

  comp->factory = NULL;
}

GtkType
gnome_db_component_get_type (void)
{
  static GtkType db_component_type = 0;

  if (!db_component_type)
    {
      GtkTypeInfo db_component_info =
      {
	"GnomeDbComponent",
	sizeof (GnomeDbComponent),
	sizeof (GnomeDbComponentClass),
	(GtkClassInitFunc) gnome_db_component_class_init,
	(GtkObjectInitFunc) gnome_db_component_init,
	(GtkArgSetFunc) NULL,
	(GtkArgSetFunc) NULL
      };
      db_component_type = gtk_type_unique(bonobo_object_get_type(), &db_component_info);
    }
  return db_component_type;
}

/**
 * gnome_db_component_new
 */
GtkObject *
gnome_db_component_new (const gchar *id)
{
  GnomeDbComponent* comp;
  gchar*            factory_id;

  g_return_val_if_fail(id != NULL, NULL);

  comp = GNOME_DB_COMPONENT(gtk_type_new(gnome_db_component_get_type()));

  /* create factory */
  factory_id = g_strdup_printf("component-factory:%s", id);
  comp->factory = bonobo_generic_factory_new(factory_id, component_factory, NULL);
  g_free((gpointer) factory_id);

  if (!comp->factory)
    {
      g_warning("Could not register component factory");
      gnome_db_component_destroy(GNOME_DB_COMPONENT(comp));
      return NULL;
    }

  return GTK_OBJECT(comp);
}

static void
gnome_db_component_destroy (GnomeDbComponent *comp)
{
  g_return_if_fail(GNOME_DB_IS_COMPONENT(comp));
}
