/* GNOME DB components provider
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#if !defined(__gda_components_h__)
#  define __gda_components_h__

#if defined(HAVE_CONFIG_H)
#  include <config.h>
#endif
#include <libgnorba/gnorba.h>
#include <gnome-db-factory.h>
#include <gnome-db-component.h>
#include <gnome-db-control.h>
#include <gnome-db-control-defprops.h>
#include <gda-ui.h>

/* connection management */
void            components_connection_init (void);
Gda_Connection* components_connection_open (const gchar *gda_name,
					    const gchar *username,
					    const gchar *password);

/* factories */
void       components_factory_init         (void);

GtkWidget* components_grid_new_widget      (void);
void       components_grid_new_instance_cb (GnomeDbControl *control,
						   GnomeDbControlInstance *control_instance,
						   gpointer user_data);
void       components_grid_set_property_cb (GnomeDbControl *control,
						   GnomeDbControlInstance *control_instance,
						   const gchar *name,
						   gpointer user_data);

GtkWidget* components_browser_new_widget      (void);
void       components_browser_new_instance_cb (GnomeDbControl *control,
						   GnomeDbControlInstance *control_instance,
						   gpointer user_data);
void       components_browser_set_property_cb (GnomeDbControl *control,
						   GnomeDbControlInstance *control_instance,
						   const gchar *name,
						   gpointer user_data);

#endif






