/* GNOME DB components provider
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gda-components.h>

typedef struct
{
  Gda_Connection* cnc;
} browser_data_t;

/*
 * Callbacks
 */

/*
 * Public functions
 */
GtkWidget *
components_browser_new_widget (void)
{
  GtkWidget* browser;

  browser = gnome_db_browser_new(NULL);
  return browser;
}

void
components_browser_new_instance_cb (GnomeDbControl *control,
				    GnomeDbControlInstance *control_instance,
				    gpointer user_data)
{
  browser_data_t* brw_data;

  g_return_if_fail(GNOME_DB_IS_CONTROL(control));
  g_return_if_fail(control_instance != NULL);

  /* set control instance properties */
  gnome_db_control_add_property(control_instance, GNOME_DB_CONTROL_PROP_DSN,
				_("Data Source Name"),
				GNOME_DB_CONTROL_ARG_STRING,
				"");
  gnome_db_control_add_property(control_instance, GNOME_DB_CONTROL_PROP_IDENT_NAME,
				_("User name to use for the connection"),
				GNOME_DB_CONTROL_ARG_STRING,
				"");
  gnome_db_control_add_property(control_instance, GNOME_DB_CONTROL_PROP_IDENT_PASS,
				_("Password to authenticate user"),
				GNOME_DB_CONTROL_ARG_STRING,
				"");
  gnome_db_control_add_property(control_instance, GNOME_DB_CONTROL_PROP_START,
				_("To open/close the connection"),
				GNOME_DB_CONTROL_ARG_BOOLEAN,
				"");

  /* create private data */
  brw_data = g_new0(browser_data_t, 1);
  gnome_db_control_set_instance_data(control_instance, (gpointer) brw_data);
}

void
components_browser_set_property_cb (GnomeDbControl *control,
				    GnomeDbControlInstance *control_instance,
				    const gchar *name,
				    gpointer user_data)
{
  browser_data_t* brw_data;

  g_return_if_fail(GNOME_DB_IS_CONTROL(control));
  g_return_if_fail(control_instance != NULL);
  g_return_if_fail(name != NULL);

  brw_data = (browser_data_t *) gnome_db_control_get_instance_data(control_instance);
  if (brw_data)
    {
      g_warning("set_property called for %s", name);

      /* only react to the 'start' property */
      if (!g_strcasecmp(name, GNOME_DB_CONTROL_PROP_START))
	{
	  gboolean to_open = gnome_db_control_get_boolean(control_instance, name);

	  g_warning("user %s password %s",
		    gnome_db_control_get_string(control_instance, GNOME_DB_CONTROL_PROP_IDENT_NAME),
		    gnome_db_control_get_string(control_instance, GNOME_DB_CONTROL_PROP_IDENT_PASS));
		    
	  gnome_db_browser_clear(GNOME_DB_BROWSER(control_instance->widget));
	  if (to_open)
	    {
	      brw_data->cnc =
		components_connection_open(gnome_db_control_get_string(control_instance, GNOME_DB_CONTROL_PROP_DSN),
					   gnome_db_control_get_string(control_instance, GNOME_DB_CONTROL_PROP_IDENT_NAME),
					   gnome_db_control_get_string(control_instance, GNOME_DB_CONTROL_PROP_IDENT_PASS));
	      gnome_db_browser_set_connection(GNOME_DB_BROWSER(control_instance->widget),
					      brw_data->cnc);
	    }
	}
    }
}

