/* GNOME DB library
 * Copyright (C) 1999 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#if !defined(_GDA_UI_H_)
#  define _GDA_UI_H_

#include <gnome.h>

#include <gda-client.h>
#include <gnome-db-browser.h>
#include <gnome-db-combo.h>
#include <gnome-db-dsn-config.h>
#include <gnome-db-error.h>
#include <gnome-db-error-dlg.h>
#include <gnome-db-grid.h>
#include <gnome-db-icon-list.h>
#include <gnome-db-dataset.h>
#include <gnome-db-xml-viewer.h>
#include <gnome-db-log-viewer.h>
#include <gnome-db-list.h>
#include <gnome-db-login.h>
#include <gnome-db-login-dlg.h>
#include <gnome-db-report.h>

BEGIN_GNOME_DECLS

/*
 * Common widgets creation
 */
GtkWidget* gda_ui_new_button_widget             (gchar *);
GtkWidget* gda_ui_new_button_widget_with_pixmap (const gchar *, const gchar *);
GtkWidget* gda_ui_new_check_button_widget       (gchar *, gint );
GtkWidget* gda_ui_new_clist_widget              (gchar *[], gint );
GtkWidget* gda_ui_new_color_picker_widget       (void);
GtkWidget* gda_ui_new_ctree_widget              (gchar *[], gint );
GtkWidget* gda_ui_new_combo_widget              (void);
GtkWidget* gda_ui_new_entry_widget              (gint , gboolean );
GtkWidget* gda_ui_new_file_entry_widget         (const gchar *history_id);
GtkWidget* gda_ui_new_file_viewer_widget        (const gchar *file);
GtkWidget* gda_ui_new_font_picker_widget        (void);
GtkWidget* gda_ui_new_frame_widget              (const gchar *label);
GtkWidget* gda_ui_new_grid_widget               (Gda_Recordset *recset);
GtkWidget* gda_ui_new_icon_widget               (const gchar *);
GtkWidget* gda_ui_new_label_widget              (const gchar *);
GtkWidget* gda_ui_new_menu_item_widget          (GtkMenu *menu, const gchar *label);
GtkWidget* gda_ui_new_notebook_widget           (void);
GtkWidget* gda_ui_new_option_menu_widget        (void);
GtkWidget* gda_ui_new_radio_button_widget       (const gchar *, GtkRadioButton *);
GtkWidget* gda_ui_new_scrolled_window_widget    (void);
GtkWidget* gda_ui_new_table_widget              (guint cols, guint rows, gboolean homogenous);
GtkWidget* gda_ui_new_text_widget               (void);
GtkWidget* gda_ui_new_toolbar_widget            (GtkOrientation orientation,
						 GtkToolbarStyle style,
						 GnomeUIInfo uiinfo[],
						 gpointer user_data);
GtkWidget* gda_ui_new_tree_widget               (void);

/*
 * Common dialogs
 */
gchar* gda_ui_select_file (const gchar *title);
void   gda_ui_show_error  (const gchar *, ...);
void   gda_ui_show_file   (const gchar *);

/*
 * GDA UI utility functions (private use)
 */
void         gda_ui_clear_clist        (GtkCList *);
GnomePixmap* gda_ui_get_pixmap         (const gchar *stock_pixmap);
GtkWidget*   gda_ui_new_popup_menu     (GtkWidget *, GnomeUIInfo *, gpointer );
void         gda_ui_show_about_dialog  (const gchar *title);

void         gda_ui_load_window_config (const gchar *name, GtkWidget *window);
void         gda_ui_save_window_config (const gchar *name, GtkWidget *window);

/*
 * Printer support
 */
void gda_ui_print_setup_dlg_cb (GtkWidget *w, gpointer data);

END_GNOME_DECLS

#endif
