/* GNOME-DB - GUI front-end
 * Copyright (c) 1998-2000 by Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#if !defined(__gdafe_h__)
#  define __gdafe_h__

#if defined(HAVE_CONFIG_H)
#  include <config.h>
#endif

#include <gnome.h>
#include <gda-ui.h>

/*
 * Data types
 */
typedef struct
{
  Gda_Connection* cnc;
  GtkWidget*      view_window;
  GtkWidget*      pane;
  GtkWidget*      sql_window;
  GtkWidget*      grid;
  gchar*          dsn;
  gchar*          trace_file;
} FE_ConnectionInfo;

/*
 * Application configuration
 */
extern void   fe_add_recent_command  (const gchar *sql_command);
extern GList* fe_get_recent_commands (void);
extern void   fe_init_gnome_session  (void);
extern void   fe_load_settings       (GtkWidget *w, gpointer data);
extern void   fe_save_settings       (GtkWidget *w, gpointer data);

/*
 * GDA library interface
 */
extern void               fe_disconnect             (GtkWidget *w, gpointer data);
extern void               fe_disconnect_all         (GtkWidget *w, gpointer data);
extern FE_ConnectionInfo* fe_get_current_connection (void);
extern void               fe_login                  (GtkWidget *w, gpointer data);
extern void               fe_open_sql_window        (Gda_Connection *, gchar *);
extern void               fe_set_server_trace       (GtkWidget *w, gpointer data);
extern void               fe_show_connection_info   (GtkWidget *w, gpointer data);
extern void               fe_view_server_trace      (GtkWidget *w, gpointer data);

extern void               fe_begin_transaction      (GtkWidget *w, gpointer data);
extern void               fe_commit_transaction     (GtkWidget *w, gpointer data);
extern void               fe_rollback_transaction   (GtkWidget *w, gpointer data);

/*
 * UI stuff
 */
#define FE_LIST_ITEM_DATA_KEY "FE_List_ItemData"

extern GtkWidget* fe_add_list_item            (GtkList *list, const gchar *text);
extern void       fe_fill_gtk_list_with_glist (GtkList *gtklist, GList *glist);
extern gchar*     fe_get_combo_current_string (GtkCombo *combo);
extern gchar*     fe_get_file_name            (gchar *title);
extern gchar*     fe_get_list_current_string  (GtkList *list);
extern void       fe_insert_file_into_text    (GtkText *text, gchar *filename);
extern gboolean   fe_is_radio_button_active   (GtkRadioButton *radio_button);
extern void       fe_load_file_in_text        (GtkText *text, gchar *filename);
extern gboolean   fe_save_text_to_file        (GtkText *text, gchar *filename);
extern void       fe_set_notebook_page        (GtkNotebook *notebook, GtkWidget *tab);
extern void       fe_show_message             (const gchar *format, ...);
extern void       fe_status_bar_message       (const gchar *format, ...);
extern gboolean   fe_yes_no_dialog            (const gchar *format, ...);

extern GtkWidget* fe_new_browse_button_widget (GtkEntry *);
extern GtkWidget* fe_new_grid_widget          (Gda_Recordset *);
extern GtkWidget* fe_new_list_widget          (void);
extern GtkWidget* fe_new_text_widget          (void);
extern GtkWidget* fe_new_toggle_button_widget (gchar *, gint );
extern GtkWidget* fe_new_toolbar_widget       (GtkOrientation , GtkToolbarStyle );

/* Notebook's views */
typedef void (*FE_DestroyViewFunc)(GtkWidget *, gpointer );

extern GtkWidget*         fe_new_view              (const gchar *title,
                                                    gint cols, gint rows, 
                                                    GnomeUIInfo *toolbar);
extern void               fe_destroy_view          (GtkWidget *view);
extern void               fe_destroy_all_views     (void);
extern GtkWidget*         fe_get_current_view      (void);
extern void               fe_display_view          (GtkWidget *view);
extern gpointer           fe_get_view_data         (GtkWidget *view, const gchar *key);
extern void               fe_set_view_data         (GtkWidget *view,
                                                    const gchar *key, 
                                                    gpointer data);
extern FE_DestroyViewFunc fe_get_view_destroy_func (GtkWidget *view);
extern void               fe_set_view_destroy_func (GtkWidget *view, 
                                                    FE_DestroyViewFunc func,
                                                    gpointer data);
extern void               fe_add_toolbar_to_view   (GtkWidget *view, 
                                                    gint x1, gint y1,
                                                    gint x2, gint y2, 
                                                    GnomeUIInfo *data);
extern void               fe_add_widget_to_view    (GtkWidget *view, 
                                                    gint x1, gint y1,
                                                    gint x2, gint y2, 
                                                    GtkWidget *widget);
extern GtkWidget*         fe_get_view_toolbar      (GtkWidget *view);

/*
 * App Utilities
 */
extern void fe_open_browser    (GtkWidget *w, gpointer data);
extern void fe_open_config     (GtkWidget *w, gpointer data);
extern void fe_open_editor     (GtkWidget *w, gpointer data);
extern void fe_open_export     (GtkWidget *w, gpointer data);
extern void fe_open_gda_config (GtkWidget *w, gpointer data);
extern void fe_open_import     (GtkWidget *w, gpointer data);
extern void fe_open_log        (GtkWidget *w, gpointer data);
extern void fe_open_designer   (GtkWidget *w, gpointer data);
extern void fe_run_app         (GtkWidget *w, const gchar *cmd);
extern void fe_run_shell       (GtkWidget *w, gpointer data);
extern void fe_util_calculator (GtkWidget *w, gpointer data);

/*
 * Global variables
 */
extern GnomeApp*  glb_App;				/* application window */
extern CORBA_ORB  glb_Orb;				/* CORBA connection */
extern GtkWidget* glb_WorkArea;			/* notebook */
extern GtkWidget* glb_StatusBar;        /* status bar */
extern GdkFont*   glb_EditorFont;       /* editor font */
extern GdkFont*   glb_GridFont;         /* grid font */

/*
 * Configuration files strings
 */
#define FE_CONFIG_SECTION_DATASOURCES      "/gdalib/Datasources"
#define FE_CONFIG_SECTION_ENVIRONMENT      "/gdafe/Environment"
#define FE_CONFIG_SECTION_GENERAL          "/gdafe/General"
#define FE_CONFIG_SECTION_SQL_COMMANDS     "/gdafe/SQLCommands"

#define FE_CONFIG_GENERAL_EDITOR_FONT      "/gdafe/General/EditorFont"
#define FE_CONFIG_GENERAL_GRID_FONT        "/gdafe/General/GridFont"
#define FE_CONFIG_GENERAL_LANGUAGE         "/gdafe/General/Language"
#define FE_CONFIG_GENERAL_SAVE_ON_EXIT     "/gdafe/General/SaveOnExit"
#define FE_CONFIG_GENERAL_CONNECT_ON_ENTRY "/gdafe/General/ConnectOnEntry"
#define FE_CONFIG_GENERAL_SHELL            "/gdafe/General/Shell"

#define FE_CONFIG_MAIN_WINDOW_X            "/gdafe/Placement/x"
#define FE_CONFIG_MAIN_WINDOW_Y            "/gdafe/Placement/y"
#define FE_CONFIG_MAIN_WINDOW_WIDTH        "/gdafe/Placement/width"
#define FE_CONFIG_MAIN_WINDOW_HEIGHT       "/gdafe/Placement/height"
#define FE_CONFIG_DOCUMENT_TABS            "/gdafe/Placement/DocTabs"

#endif
