/* Sample Rolodex Application
 * Copyright (C) 1998,1999 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gnome.h>
#include "rolonav.h"

static void        rolonav_class_init    (RolonavClass* klass);
static void        rolonav_init          (Rolonav*      nav);
static void        rolonav_destroy       (GtkObject*    obj);

guint
rolonav_get_type(void)
{
  static guint rnav_type = 0;

  if (!rnav_type)
    {
      GtkTypeInfo rnav_info =
      {
	"Rolonav",
	sizeof(Rolonav),
	sizeof(RolonavClass),
	(GtkClassInitFunc)rolonav_class_init,
	(GtkObjectInitFunc)rolonav_init,
	(GtkArgSetFunc) NULL,
	(GtkArgGetFunc) NULL,
      };
      rnav_type = gtk_type_unique(gtk_hbox_get_type(), &rnav_info);
    }
  return rnav_type;
}



static void
rolonav_class_init(RolonavClass* klass)
{
  GtkObjectClass* object_class;

  object_class = (GtkObjectClass*) klass;
  object_class->destroy = rolonav_destroy;
  
  klass->next = 0;
  klass->previous = 0;
  
}

static void
rolonav_next(GtkWidget* button, gpointer data)
{
  Rolonav* nav = ROLONAV(data);
  float    value = nav->adjustment->value;

  value++;
  gtk_adjustment_set_value(nav->adjustment, value);
}


static void
rolonav_prev(GtkWidget* button, gpointer data)
{
  Rolonav* nav = ROLONAV(data);
  float    value = nav->adjustment->value;

  value--;
  gtk_adjustment_set_value(nav->adjustment, value);
}


static void
adjust_buttons(GtkObject* obj, gpointer data)
{
  Rolonav* nav = ROLONAV(data);
  GtkAdjustment* adj = GTK_ADJUSTMENT(obj);
  GtkWidget* new_upper_pixmap = 0;
  GtkWidget* new_lower_pixmap = 0;

  g_return_if_fail(GTK_IS_WIDGET(nav->upper_half_empty));
  g_return_if_fail(GTK_IS_WIDGET(nav->upper_half_full));
  g_return_if_fail(GTK_IS_WIDGET(nav->lower_half_empty));
  g_return_if_fail(GTK_IS_WIDGET(nav->lower_half_full));
  
  
  if (adj->value == adj->lower)

    {
      new_upper_pixmap = nav->upper_half_empty;
    }
  else
    {
      new_upper_pixmap = nav->upper_half_full;
    }

  if (adj->value == adj->upper)
    {
      new_lower_pixmap = nav->lower_half_empty;
    }
  else
    {
      new_lower_pixmap = nav->lower_half_full;
    }

  if (nav->upper_pixmap != new_upper_pixmap)
    {
      if (nav->upper_pixmap)
	{
	  gtk_container_remove(GTK_CONTAINER(nav->upper_button), nav->upper_pixmap);
	}
      gtk_container_add(GTK_CONTAINER(nav->upper_button), new_upper_pixmap);
      gtk_widget_show(new_upper_pixmap);
      nav->upper_pixmap = new_upper_pixmap;
    }
  
  if (nav->lower_pixmap != new_lower_pixmap)
    {
      if (nav->lower_pixmap)
	{
	  gtk_container_remove(GTK_CONTAINER(nav->lower_button), nav->lower_pixmap);
	}
      gtk_container_add(GTK_CONTAINER(nav->lower_button), new_lower_pixmap);
      gtk_widget_show(new_lower_pixmap);
      nav->lower_pixmap = new_lower_pixmap;
    }
}

static void
rolonav_init(Rolonav* nav)
{
  GtkWidget* vbox;
  
  nav->upper_pixmap = 0;
  nav->lower_pixmap = 0;

  nav->glue = gnome_pixmap_new_from_file_at_size(gnome_pixmap_file("gnome-db/rings.png"), 80,8);

  nav->upper_half_empty = gnome_pixmap_new_from_file_at_size(gnome_pixmap_file("gnome-db/empty.png"), 80, 40);
  nav->lower_half_empty = gnome_pixmap_new_from_file_at_size(gnome_pixmap_file("gnome-db/empty.png"), 80, 40);

  nav->upper_half_full = gnome_pixmap_new_from_file_at_size(gnome_pixmap_file("gnome-db/full.png"), 80, 40);
  nav->lower_half_full = gnome_pixmap_new_from_file_at_size(gnome_pixmap_file("gnome-db/full.png"), 80, 40);

  gtk_object_ref(GTK_OBJECT(nav->upper_half_empty));
  gtk_object_ref(GTK_OBJECT(nav->upper_half_full));
  
  gtk_object_ref(GTK_OBJECT(nav->lower_half_empty));
  gtk_object_ref(GTK_OBJECT(nav->lower_half_full));
  
  nav->upper_button = gtk_button_new();
  nav->lower_button = gtk_button_new();

  gtk_button_set_relief(GTK_BUTTON(nav->upper_button), GTK_RELIEF_NONE);
  gtk_button_set_relief(GTK_BUTTON(nav->lower_button), GTK_RELIEF_NONE);
  
  gtk_container_set_border_width(GTK_CONTAINER(nav->upper_button), 0);
  gtk_container_set_border_width(GTK_CONTAINER(nav->lower_button), 0);
  
  gtk_signal_connect(GTK_OBJECT(nav->upper_button), "clicked",
		     GTK_SIGNAL_FUNC(rolonav_prev), nav);
  gtk_signal_connect(GTK_OBJECT(nav->lower_button), "clicked",
		     GTK_SIGNAL_FUNC(rolonav_next), nav);

  gtk_signal_connect(GTK_OBJECT(nav), "destroy",
		     GTK_SIGNAL_FUNC(rolonav_destroy), 0);
  
  vbox = gtk_vbox_new(0, 0);
  gtk_box_pack_start(GTK_BOX(vbox), nav->upper_button, 0, 0, 0);
  gtk_box_pack_start(GTK_BOX(vbox), nav->glue, 0, 0, 0);
  gtk_box_pack_start(GTK_BOX(vbox), nav->lower_button, 0, 0, 0);
  
  gtk_box_pack_start(GTK_BOX(nav), vbox, 0, 0, 0);
  gtk_widget_show_all(GTK_WIDGET(nav));

}


GtkWidget*
rolonav_new(GtkAdjustment* adjustment)
{
  Rolonav* nav;

  nav = gtk_type_new(rolonav_get_type());
  nav->adjustment = adjustment;
  gtk_signal_connect_after(GTK_OBJECT(adjustment),
			   "value-changed",
			   GTK_SIGNAL_FUNC(adjust_buttons),
			   nav);
  adjust_buttons(GTK_OBJECT(adjustment), nav);
  
  return GTK_WIDGET(nav);
}


static void
rolonav_destroy(GtkObject* obj)
{
  Rolonav* nav = ROLONAV(obj);

  g_print("rolonav_destroy called\n");
  gtk_object_unref(GTK_OBJECT(nav->upper_half_empty));
  gtk_object_unref(GTK_OBJECT(nav->upper_half_full));
  
  gtk_object_unref(GTK_OBJECT(nav->lower_half_empty));
  gtk_object_unref(GTK_OBJECT(nav->lower_half_full));
}  
  
