/* GNOME DB libary
 * Copyright (C) 1998,1999 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GDA_MYSQL_CONNECTION_H__
#define __GDA_MYSQL_CONNECTION_H__ 1

#include "gda-mysql-types.h"


Gda_MYSQL_Connection* gda_mysql_connection_new         (void);
gint                  gda_mysql_connection_open        (Gda_MYSQL_Connection* cnc,
                                                        const gchar* dsn,
                                                        const gchar* user,
                                                        const gchar* passwd);
						     
gint                  gda_mysql_connection_close       (Gda_MYSQL_Connection* cnc);

Gda_MYSQL_Recordset*  gda_mysql_connection_open_schema (Gda_MYSQL_Connection* cnc,
                                                        Gda_MYSQL_Error* e,
                                                        GDA_Connection_QType t,
                                                        GDA_Connection_Constraint* constraints,
                                                        gint length);

gboolean              gda_mysql_connection_supports    (Gda_MYSQL_Connection* cnc,
                                                        GDA_Connection_Feature feature);

#endif



