/* GDA Manager
 * Copyright (C) 1998,1999 Michael Lausch
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#if !defined(__gda_mgr_h__)
#  define __gda_mgr_h__

#include <gda-ui.h>
#if defined(HAVE_CONFIG_H)
#  include <config.h>
#endif

#if !defined(GDA_CONFIG_DIR)
#  define GDA_CONFIG_DIR "/usr/local/etc/gnome-db"
#endif

/*
 * GDA system-wide configuration
 */
extern void manager_gda_init (void);

/*
 * Global variables
 */
extern GtkWidget* glb_App;
extern GtkWidget* glb_Notebook;
extern GtkWidget* glb_StatusBar;
extern CORBA_ORB  glb_Orb;

/*
 * Configuration files strings
 */
#define MANAGER_CONFIG_MAIN_WINDOW_X            "/gda-mgr/Placement/x"
#define MANAGER_CONFIG_MAIN_WINDOW_Y            "/gda-mgr/Placement/y"
#define MANAGER_CONFIG_MAIN_WINDOW_WIDTH        "/gda-mgr/Placement/width"
#define MANAGER_CONFIG_MAIN_WINDOW_HEIGHT       "/gda-mgr/Placement/height"
#define MANAGER_CONFIG_DOCUMENT_TABS            "/gda-mgr/Placement/DocTabs"

#endif
