/* GDA Manager
 * Copyright (C) 1998,1999 Michael Lausch
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gda-mgr.h"

#if !defined(GNOMELOCALEDIR)
#  define GNOMELOCALEDIR "/usr/locale"
#endif

static void about_cb (GtkWidget *w, gpointer data);
static void quit_cb  (GtkWidget *w, gpointer data);

static void load_config (void);
static void prepare_app (void);
static void save_config (void);

/* global variables */
GtkWidget*      glb_App = 0;
GtkWidget*      glb_Notebook = 0;
GtkWidget*      glb_StatusBar = 0;
CORBA_ORB       glb_Orb;

/* menus */
GnomeUIInfo filemenu[] =
{
  { GNOME_APP_UI_ITEM, N_("Reload"), N_("Reload config drivers"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_REFRESH, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Quit"), N_("Exit application"),
    quit_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_QUIT, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo helpmenu[] =
{
  GNOMEUIINFO_HELP("gnome-db"),
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("About gnome-db..."), N_("About this program"),
    about_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_ABOUT, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo mainmenu[] =
{
  GNOMEUIINFO_SUBTREE(N_("File"), filemenu),
  GNOMEUIINFO_SUBTREE(N_("Help"), helpmenu),
  GNOMEUIINFO_END
};

/* toolbar */
GnomeUIInfo toolbar[] =
{
  { GNOME_APP_UI_ITEM, N_("Reload"), N_("Reload config drivers"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_REFRESH, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Preferences"), N_("Configure user preferences"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_PREF, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Quit"), N_("Exit application"),
    quit_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_EXIT, 0, 0, NULL },
  GNOMEUIINFO_END
};

/* CORBA exception handler */
void
Exception (CORBA_Environment *ev)
{
  switch (ev->_major)
    {
    case CORBA_SYSTEM_EXCEPTION :
      gda_ui_show_error("CORBA system exception %s", CORBA_exception_id(ev));
      exit(1);
    case CORBA_USER_EXCEPTION :
      gda_ui_show_error("CORBA user exception %s", CORBA_exception_id(ev));
      exit(1);
    default :
      break;
    }
}

gint 
main (gint argc, gchar *argv[])
{
  CORBA_Environment ev;

  /* initialize the i18n stuff */
  bindtextdomain(PACKAGE, GNOMELOCALEDIR);
  textdomain(PACKAGE);

  /* initialize CORBA stuff */
  CORBA_exception_init(&ev);
  glb_Orb = gnome_CORBA_init("gda-mgr", VERSION, &argc, argv, 0, &ev);
  Exception(&ev);

  /* load application settings and create main window */
  load_config();
  prepare_app();

  /* main loop */
  gtk_main();
  return (0);
}

/*
 * Callbacks
 */
static void 
about_cb (GtkWidget *w, gpointer data)
{
  const gchar *authors[] = { "Michael Lausch <michael@lausch.at>",
                             "Rodrigo Moya <rmoya@chez.com>",
                             "Stephan Heinze <stephan.heinze@xcom.de>",
                             "Vivien Malerba <malerba@linuxbox.com>",
                             NULL };
  GtkWidget *about = gnome_about_new(_("GNOME-DB Manager"), VERSION,
	     _("Copyright The Free Software Foundation (C) 1998-2000"),
	     authors,
             _("This program is part of the GNOME project for LINUX. "
	       "GNOME Data Access comes with ABSOLUTELY NO WARRANTY. "
	       "This is free software, and you are welcome to redistribute "
	       "it under the conditions of the GNU General Public Licence."),
	     "gnome-db.png");
  gtk_widget_show(about);
}

static gint
die_session_cb (GnomeClient *client, gpointer client_data)
{
  gtk_exit(0);
  return FALSE;
}

static void 
quit_cb (GtkWidget *w, gpointer data)
{
  save_config();
  gtk_main_quit();
}

static gint
save_yourself_cb (GnomeClient *client, 
                  gint phase, 
	          GnomeRestartStyle restart_style,
	          gint shutdown,
	          GnomeInteractStyle interact_style,
  	          gint fast, 
  	          gpointer client_data)
{
  save_config();
  return TRUE;
}

/*
 * Private functions
 */
static void
load_config (void)
{
  GnomeClient* session;

  /* init session */
  session = gnome_master_client();
  gtk_signal_connect(GTK_OBJECT(session), "save_yourself",
		     GTK_SIGNAL_FUNC(save_yourself_cb), NULL);
  gtk_signal_connect(GTK_OBJECT(session), "die",
  		     GTK_SIGNAL_FUNC(die_session_cb), NULL);
}

static void
prepare_app (void)
{
  GtkWidget *pane;
  
  glb_App = gnome_app_new("gda-mgr", "GDA Manager");
  gtk_widget_realize(GTK_WIDGET(glb_App));
  gtk_signal_connect(GTK_OBJECT(glb_App), "delete_event",
                     GTK_SIGNAL_FUNC(quit_cb), NULL);
  gtk_signal_connect(GTK_OBJECT(glb_App), "destroy",
                     GTK_SIGNAL_FUNC(quit_cb), NULL);

  /* get saved window position */
  gdk_window_move(GTK_WIDGET(glb_App)->window,
                  gnome_config_get_int(MANAGER_CONFIG_MAIN_WINDOW_X),
                  gnome_config_get_int(MANAGER_CONFIG_MAIN_WINDOW_Y));
  gtk_widget_set_usize(GTK_WIDGET(glb_App),
                       gnome_config_get_int(MANAGER_CONFIG_MAIN_WINDOW_WIDTH),
                       gnome_config_get_int(MANAGER_CONFIG_MAIN_WINDOW_HEIGHT));
  gtk_widget_show(GTK_WIDGET(glb_App));
                  
  /* set main window contents */
  gnome_app_create_toolbar(GNOME_APP(glb_App), toolbar);
  glb_Notebook = gda_ui_new_notebook_widget();
  gnome_app_set_contents(GNOME_APP(glb_App), glb_Notebook);
  gnome_app_create_menus(GNOME_APP(glb_App), mainmenu);

  /* create status bar */
  glb_StatusBar = gnome_appbar_new(TRUE, TRUE, GNOME_PREFERENCES_USER);
  gnome_appbar_set_default(GNOME_APPBAR(glb_StatusBar), _("Ready"));
  gnome_app_set_statusbar(GNOME_APP(glb_App), glb_StatusBar);
  gnome_app_install_menu_hints(GNOME_APP(glb_App), mainmenu);
  
  gtk_widget_show(glb_App);

  /* add "GDA Configuration" tab */
  manager_gda_init();
}

static void
save_config (void)
{
  gint x, y, width, height;

  gdk_window_get_geometry(GTK_WIDGET(glb_App)->window, &x, &y, &width, &height, NULL);
  gnome_config_set_int(MANAGER_CONFIG_MAIN_WINDOW_X, x);
  gnome_config_set_int(MANAGER_CONFIG_MAIN_WINDOW_Y, y);
  gnome_config_set_int(MANAGER_CONFIG_MAIN_WINDOW_WIDTH, width);
  gnome_config_set_int(MANAGER_CONFIG_MAIN_WINDOW_HEIGHT, height);

  gnome_config_sync();
}