/* GNOME DB libary
 * Copyright (C) 1999-2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __gnome_db_xml_viewer_h__
#define __gnome_db_xml_viewer_h__ 1

#include <gda-xml.h>

BEGIN_GNOME_DECLS

#define GNOME_DB_TYPE_XML_VIEWER            (gnome_db_xml_viewer_get_type())
#define GNOME_DB_XML_VIEWER(obj)            GTK_CHECK_CAST(obj, GNOME_DB_TYPE_XML_VIEWER, GnomeDbXmlViewer)
#define GNOME_DB_XML_VIEWER_CLASS(klass)    GTK_CHECK_CLASS_CAST(klass, GNOME_DB_TYPE_XML_VIEWER, GnomeDbIconListClass)
#define GNOME_DB_IS_XML_VIEWER(obj)         GTK_CHECK_TYPE(obj, GNOME_DB_TYPE_XML_VIEWER)
#define GNOME_DB_IS_XML_VIEWER_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_DB_TYPE_XML_VIEWER))

typedef struct _GnomeDbXmlViewer      GnomeDbXmlViewer;
typedef struct _GnomeDbXmlViewerClass GnomeDbXmlViewerClass;

struct _GnomeDbXmlViewer
{
  GtkVBox          vbox;
  GtkWidget*       tree;
  GList*           nodes;
  GtkWidget*       description;
  GtkWidget*       dbname_entry;
  GtkWidget*       filename_entry;
  Gda_XmlDatabase* db;
  Gda_XmlObject*   selected_object;
};

struct _GnomeDbXmlViewerClass
{
  GtkVBoxClass parent_class;
  
  void         (*database_changed)(GnomeDbXmlViewer *viewer);
};

guint            gnome_db_xml_viewer_get_type      (void);
GtkWidget*       gnome_db_xml_viewer_new           (Gda_XmlDatabase *db);
GtkWidget*       gnome_db_xml_viewer_new_from_file (const gchar *filename);
void             gnome_db_xml_viewer_clear         (GnomeDbXmlViewer *db);
void             gnome_db_xml_viewer_load_file     (GnomeDbXmlViewer *db,
                                                    const gchar *filename);

Gda_XmlDatabase* gnome_db_xml_viewer_get_database  (GnomeDbXmlViewer *viewer);
void             gnome_db_xml_viewer_set_database  (GnomeDbXmlViewer *viewer,
                                                    Gda_XmlDatabase *db);
Gda_XmlObject*   gnome_db_xml_viewer_get_selected  (GnomeDbXmlViewer *viewer);

END_GNOME_DECLS

#endif
