/* GNOME-DB - GUI front-end
 * Copyright (c) 1998-2000 by Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gdafe.h"

static GtkWidget* l_CalcDialog = 0;

static void
dialog_clicked_cb (GnomeDialog *dialog, gint button_number, gpointer data)
{
  gnome_dialog_close(dialog);
  l_CalcDialog = 0;
}

void
fe_util_calculator (GtkWidget *w, gpointer data)
{
  GtkWidget *calc;
  
  if (l_CalcDialog == 0)
    {
      l_CalcDialog = gnome_dialog_new(_("Calculator"), GNOME_STOCK_BUTTON_CLOSE, 0);
      gtk_signal_connect(GTK_OBJECT(l_CalcDialog), "clicked",
                         GTK_SIGNAL_FUNC(dialog_clicked_cb), 0);
      calc = gnome_calculator_new();
      gtk_widget_show(calc);
      gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(l_CalcDialog)->vbox), calc, 1, 1, 0);
    }
  gtk_widget_show(l_CalcDialog);
}