/* GNOME-DB - GUI front-end
 * Copyright (c) 1998-2000 by Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gdafe.h"

/*
 * Public functions
 */
void
fe_set_server_trace (GtkWidget *w, gpointer data)
{
  FE_ConnectionInfo *cnc_info = fe_get_current_connection();
  if (cnc_info != NULL)
    {
      if (cnc_info->trace_file != NULL)
        {
          /* trace already enabled, stop it */
          if (!gda_connection_stop_logging(cnc_info->cnc))
            {
              g_free((gpointer) cnc_info->trace_file);
              cnc_info->trace_file = NULL;
              fe_status_bar_message(_("Server trace stopped"));
            }
        }
      else
        {
          /* start logging for this connection */
          gchar *file_name = fe_get_file_name(_("Select Trace File"));
          if (file_name != NULL)
            {
              if (!gda_connection_start_logging(cnc_info->cnc, file_name))
                {
                  cnc_info->trace_file = file_name;
                  fe_status_bar_message(_("Server trace to file %s started"), file_name);
                }
              else g_free((gpointer) file_name);
            }
        }
    }
}

void
fe_view_server_trace (GtkWidget *w, gpointer data)
{
  FE_ConnectionInfo *cnc_info = fe_get_current_connection();
  if (cnc_info != NULL)
    {
      GtkWidget *dialog, *viewer;
      
      if (cnc_info->trace_file != NULL)
        {
          dialog = gnome_dialog_new(_("Server Trace File"),
                                    GNOME_STOCK_BUTTON_CLOSE, NULL);
          gtk_widget_set_usize(dialog, 400, 350);
          viewer = gnome_less_new();
          if (glb_EditorFont != 0)
            {
              gnome_less_set_font(GNOME_LESS(viewer), glb_EditorFont);
            }
          gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox), viewer, 1, 1, 0);
          gnome_less_show_file(GNOME_LESS(viewer),
                               (const gchar *) cnc_info->trace_file);
          gtk_widget_show(viewer);
          gnome_dialog_run_and_close(GNOME_DIALOG(dialog));
        }
      else gda_ui_show_error(_("Server trace is disabled for this connection"));
    }
}