/* GNOME-DB - GUI front-end
 * Copyright (c) 1998-2000 by Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gdafe.h"

static void close_designer_cb (GtkWidget *w, gpointer data);
static void new_file_cb       (GtkWidget *w, gpointer data);
static void new_object_cb     (GtkButton *button, gpointer data);
static void open_file_cb      (GtkWidget *w, gpointer data);
static void save_file_cb      (GtkWidget *w, gpointer data);

static GtkWidget* l_view = 0;
static GtkWidget* l_viewer = 0;
static GnomeUIInfo designertoolbar[] =
{
  { GNOME_APP_UI_ITEM, N_("New"), N_("Create new database design"),
    new_file_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_NEW, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Open"), N_("Open database design from file"),
    open_file_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_OPEN, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Save"), N_("Save database design to file"),
    save_file_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_SAVE, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Close"), N_("Close this window"),
    close_designer_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_CLOSE, 0, 0, NULL },
  GNOMEUIINFO_END
};

/*
 * Private functions
 */
static void
real_close (GtkWidget *w, gpointer data)
{
  g_return_if_fail(l_view != 0);
  l_view = 0;
}

/*
 * Callbacks
 */
static void
close_designer_cb (GtkWidget *w, gpointer data)
{
  g_return_if_fail(l_view != 0);  
  fe_destroy_view(l_view);
}

static void
new_file_cb (GtkWidget *w, gpointer data)
{
  g_return_if_fail(l_view != 0);
  gnome_db_xml_viewer_clear(GNOME_DB_XML_VIEWER(l_viewer));
}

static void
new_object_cb (GtkButton *button, gpointer data)
{
  g_return_if_fail(l_view != 0);
}

static void
open_file_cb (GtkWidget *w, gpointer data)
{
  gchar* filename;
  
  g_return_if_fail(l_view != 0);
  
  filename = fe_get_file_name(_("Open XML File"));
  if (filename)
    {
      gnome_db_xml_viewer_load_file(GNOME_DB_XML_VIEWER(l_viewer), filename);
      g_free((gpointer) filename);
    }
}

static void
save_file_cb (GtkWidget *w, gpointer data)
{
  gchar*           filename;
  gboolean         free_memory = FALSE;
  Gda_XmlDatabase* db;

  g_return_if_fail(l_view != 0);
  g_return_if_fail(GNOME_DB_IS_XML_VIEWER(l_viewer));
  g_return_if_fail(IS_GDA_XML_DATABASE(GNOME_DB_XML_VIEWER(l_viewer)->db));

  db = gnome_db_xml_viewer_get_database(GNOME_DB_XML_VIEWER(l_viewer));
  filename = gda_xml_database_get_filename(db);
  if (!filename)
    {
      filename = fe_get_file_name(_("Select File"));
      if (!filename) return;
      free_memory = TRUE;
    }
  if (!gda_xml_database_save(db, filename))
    gda_ui_show_error(_("Error saving file\n'%s'"), filename);

  /* free memory before exiting */
  if (free_memory) g_free((gpointer) filename);
}

/*
 * Public functions
 */
void
fe_open_designer (GtkWidget *w, gpointer data)
{
  GtkWidget* box, *button;
  
  if (!l_view)
    {
      l_view = fe_new_view(_("Designer"), 6, 2, designertoolbar);
      fe_set_view_destroy_func(l_view, (FE_DestroyViewFunc) real_close, NULL);
      
      /* create button bar */
      box = gtk_vbox_new(FALSE, 0);
      button = gda_ui_new_button_widget_with_pixmap(_("New"), GNOME_STOCK_MENU_SEARCH);
      gtk_button_set_relief(GTK_BUTTON(button), GTK_RELIEF_NONE);
      gtk_signal_connect(GTK_OBJECT(button), "clicked",
                         GTK_SIGNAL_FUNC(new_object_cb), (gpointer) 0);
      gtk_box_pack_start(GTK_BOX(box), button, 0, 0, 0);

      button = gda_ui_new_button_widget_with_pixmap(_("Delete"), GNOME_STOCK_MENU_TRASH);
      gtk_button_set_relief(GTK_BUTTON(button), GTK_RELIEF_NONE);
      //gtk_signal_connect(GTK_OBJECT(button), "clicked",
      //                   GTK_SIGNAL_FUNC(delete_table_cb), (gpointer) 0);
      gtk_box_pack_start(GTK_BOX(box), button, 0, 0, 0);
      
      button = gda_ui_new_button_widget_with_pixmap(_("Refresh"), GNOME_STOCK_MENU_REFRESH);
      gtk_button_set_relief(GTK_BUTTON(button), GTK_RELIEF_NONE);
      //gtk_signal_connect(GTK_OBJECT(button), "clicked",
      //                   GTK_SIGNAL_FUNC(refresh_designer_cb), (gpointer) 0);
      gtk_box_pack_start(GTK_BOX(box), button, 0, 0, 0);
      
      gtk_widget_show(box);
      fe_add_widget_to_view(l_view, 0, 1, 1, 2, box);
      
      /* create XML viewer widget */
      l_viewer = gnome_db_xml_viewer_new(0);
      fe_add_widget_to_view(l_view, 1, 1, 6, 2, l_viewer);
    }
  fe_display_view(l_view);
}