#include "gda.h"

#include "gda-sybase-types.h"

static int
Exception( CORBA_Environment* ev )
{
  switch( ev->_major )
    {
    case CORBA_SYSTEM_EXCEPTION:
      g_warning("CORBA system exception %s.", CORBA_exception_id(ev));
      return -1;
    case CORBA_USER_EXCEPTION:
      g_warning("CORBA user exception: %s.\n", CORBA_exception_id( ev ) );
      return -1;
    default:
      break;
    }
  return 0;
}


/*** App-specific servant structures ***/

typedef struct {
   POA_GNOME_GenericFactory servant;
   PortableServer_POA poa;

} impl_POA_GNOME_GenericFactory;

typedef struct {
   POA_GDA_Fieldx servant;
   PortableServer_POA poa;

} impl_POA_GDA_Fieldx;

typedef struct {
   POA_GDA_Parameter servant;
   PortableServer_POA poa;

} impl_POA_GDA_Parameter;

typedef struct {
   POA_GDA_Command servant;
   PortableServer_POA poa;
   CORBA_long attr_cmdTimeout;

   CORBA_boolean attr_prepared;

   CORBA_long attr_state;

   CORBA_char *attr_text;

   CORBA_unsigned_long attr_type;

} impl_POA_GDA_Command;

typedef struct {
   POA_GDA_Connection servant;
   PortableServer_POA poa;

   CORBA_long attr_flags;

   CORBA_long attr_cmdTimeout;

   CORBA_long attr_connectTimeout;

   GDA_CursorLocation attr_cursor;

   CORBA_char *attr_version;

   GDA_ErrorSeq attr_errors;

  Gda_SYBASE_Connection* cnc;
  
} impl_POA_GDA_Connection;

typedef struct {
   POA_GDA_Recordset servant;
   PortableServer_POA poa;

   CORBA_long attr_currentBookmark;

   CORBA_long attr_cachesize;

   GDA_CursorType attr_currentCursorType;

   GDA_LockType attr_lockingMode;

   CORBA_long attr_maxrecords;

   CORBA_long attr_pagecount;

   CORBA_long attr_pagesize;

   CORBA_long attr_recCount;

   CORBA_char *attr_source;

   CORBA_long attr_status;

} impl_POA_GDA_Recordset;

typedef struct {
   POA_GDA_ConnectionFactory servant;
   PortableServer_POA poa;

} impl_POA_GDA_ConnectionFactory;

/*** Implementation stub prototypes ***/

static void impl_GNOME_GenericFactory__destroy(impl_POA_GNOME_GenericFactory * servant,
					       CORBA_Environment * ev);

static CORBA_boolean
 impl_GNOME_GenericFactory_supports(impl_POA_GNOME_GenericFactory * servant,
				    CORBA_char * obj_goad_id,
				    CORBA_Environment * ev);

static CORBA_Object
 impl_GNOME_GenericFactory_create_object(impl_POA_GNOME_GenericFactory * servant,
					 CORBA_char * goad_id,
					 GNOME_stringlist * params,
					 CORBA_Environment * ev);

static void impl_GDA_Fieldx__destroy(impl_POA_GDA_Fieldx * servant,
				     CORBA_Environment * ev);
static CORBA_long
 impl_GDA_Fieldx_appendChunk(impl_POA_GDA_Fieldx * servant,
			     GDA_VarBinString * data,
			     CORBA_Environment * ev);

static GDA_VarBinString *
 impl_GDA_Fieldx_getChunk(impl_POA_GDA_Fieldx * servant,
			  CORBA_long amount,
			  CORBA_Environment * ev);

static void impl_GDA_Parameter__destroy(impl_POA_GDA_Parameter * servant,
					CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Parameter_appendChunk(impl_POA_GDA_Parameter * servant,
				GDA_Parameter_VarBinString * data,
				CORBA_Environment * ev);

static void impl_GDA_Command__destroy(impl_POA_GDA_Command * servant,
				      CORBA_Environment * ev);
static CORBA_long
 impl_GDA_Command__get_cmdTimeout(impl_POA_GDA_Command * servant,
				  CORBA_Environment * ev);
static void
 impl_GDA_Command__set_cmdTimeout(impl_POA_GDA_Command * servant,
				  CORBA_long value,
				  CORBA_Environment * ev);

static CORBA_boolean
 impl_GDA_Command__get_prepared(impl_POA_GDA_Command * servant,
				CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Command__get_state(impl_POA_GDA_Command * servant,
			     CORBA_Environment * ev);
static void
 impl_GDA_Command__set_state(impl_POA_GDA_Command * servant,
			     CORBA_long value,
			     CORBA_Environment * ev);

static CORBA_char *
 impl_GDA_Command__get_text(impl_POA_GDA_Command * servant,
			    CORBA_Environment * ev);
static void
 impl_GDA_Command__set_text(impl_POA_GDA_Command * servant,
			    CORBA_char * value,
			    CORBA_Environment * ev);

static CORBA_unsigned_long
 impl_GDA_Command__get_type(impl_POA_GDA_Command * servant,
			    CORBA_Environment * ev);
static void
 impl_GDA_Command__set_type(impl_POA_GDA_Command * servant,
			    CORBA_unsigned_long value,
			    CORBA_Environment * ev);

static GDA_Recordset
 impl_GDA_Command_open(impl_POA_GDA_Command * servant,
		       GDA_CmdParameterSeq * param,
		       GDA_CursorType ct,
		       GDA_LockType lt,
		       CORBA_unsigned_long * affected,
		       CORBA_Environment * ev);

static void impl_GDA_Connection__destroy(impl_POA_GDA_Connection * servant,
					 CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Connection__get_flags(impl_POA_GDA_Connection * servant,
				CORBA_Environment * ev);
static void
 impl_GDA_Connection__set_flags(impl_POA_GDA_Connection * servant,
				CORBA_long value,
				CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Connection__get_cmdTimeout(impl_POA_GDA_Connection * servant,
				     CORBA_Environment * ev);
static void
 impl_GDA_Connection__set_cmdTimeout(impl_POA_GDA_Connection * servant,
				     CORBA_long value,
				     CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Connection__get_connectTimeout(impl_POA_GDA_Connection * servant,
					 CORBA_Environment * ev);
static void
 impl_GDA_Connection__set_connectTimeout(impl_POA_GDA_Connection * servant,
					 CORBA_long value,
					 CORBA_Environment * ev);

static GDA_CursorLocation
 impl_GDA_Connection__get_cursor(impl_POA_GDA_Connection * servant,
				 CORBA_Environment * ev);
static void
 impl_GDA_Connection__set_cursor(impl_POA_GDA_Connection * servant,
				 GDA_CursorLocation value,
				 CORBA_Environment * ev);

static CORBA_char *
 impl_GDA_Connection__get_version(impl_POA_GDA_Connection * servant,
				  CORBA_Environment * ev);

static GDA_ErrorSeq *
 impl_GDA_Connection__get_errors(impl_POA_GDA_Connection * servant,
				 CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Connection_beginTransaction(impl_POA_GDA_Connection * servant,
				      CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Connection_commitTransaction(impl_POA_GDA_Connection * servant,
				       CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Connection_rollbackTransaction(impl_POA_GDA_Connection * servant,
					 CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Connection_close(impl_POA_GDA_Connection * servant,
			   CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Connection_open(impl_POA_GDA_Connection * servant,
			  CORBA_char * dsn,
			  CORBA_char * user,
			  CORBA_char * passwd,
			  CORBA_Environment * ev);

static GDA_Recordset
 impl_GDA_Connection_openSchema(impl_POA_GDA_Connection * servant,
				GDA_Connection_QType t,
				GDA_Connection_ConstraintSeq * constraints,
				CORBA_Environment * ev);

static GDA_Command
 impl_GDA_Connection_createCommand(impl_POA_GDA_Connection * servant,
				   CORBA_Environment * ev);

static GDA_Recordset
 impl_GDA_Connection_createRecordset(impl_POA_GDA_Connection * servant,
				     CORBA_Environment * ev);

static GDA_Connection_DSNlist *
 impl_GDA_Connection_listSources(impl_POA_GDA_Connection * servant,
				 CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Connection_startLogging(impl_POA_GDA_Connection * servant,
				  CORBA_char * filename,
				  CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Connection_stopLogging(impl_POA_GDA_Connection * servant,
				 CORBA_Environment * ev);

static CORBA_char *
 impl_GDA_Connection_createTable(impl_POA_GDA_Connection * servant,
				 CORBA_char * name,
				 GDA_RowAttributes * columns,
				 CORBA_Environment * ev);

static void impl_GDA_Recordset__destroy(impl_POA_GDA_Recordset * servant,
					CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset__get_currentBookmark(impl_POA_GDA_Recordset * servant,
					 CORBA_Environment * ev);
static void
 impl_GDA_Recordset__set_currentBookmark(impl_POA_GDA_Recordset * servant,
					 CORBA_long value,
					 CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset__get_cachesize(impl_POA_GDA_Recordset * servant,
				   CORBA_Environment * ev);
static void
 impl_GDA_Recordset__set_cachesize(impl_POA_GDA_Recordset * servant,
				   CORBA_long value,
				   CORBA_Environment * ev);

static GDA_CursorType
 impl_GDA_Recordset__get_currentCursorType(impl_POA_GDA_Recordset * servant,
					   CORBA_Environment * ev);
static void
 impl_GDA_Recordset__set_currentCursorType(impl_POA_GDA_Recordset * servant,
					   GDA_CursorType value,
					   CORBA_Environment * ev);

static GDA_LockType
 impl_GDA_Recordset__get_lockingMode(impl_POA_GDA_Recordset * servant,
				     CORBA_Environment * ev);
static void
 impl_GDA_Recordset__set_lockingMode(impl_POA_GDA_Recordset * servant,
				     GDA_LockType value,
				     CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset__get_maxrecords(impl_POA_GDA_Recordset * servant,
				    CORBA_Environment * ev);
static void
 impl_GDA_Recordset__set_maxrecords(impl_POA_GDA_Recordset * servant,
				    CORBA_long value,
				    CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset__get_pagecount(impl_POA_GDA_Recordset * servant,
				   CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset__get_pagesize(impl_POA_GDA_Recordset * servant,
				  CORBA_Environment * ev);
static void
 impl_GDA_Recordset__set_pagesize(impl_POA_GDA_Recordset * servant,
				  CORBA_long value,
				  CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset__get_recCount(impl_POA_GDA_Recordset * servant,
				  CORBA_Environment * ev);

static CORBA_char *
 impl_GDA_Recordset__get_source(impl_POA_GDA_Recordset * servant,
				CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset__get_status(impl_POA_GDA_Recordset * servant,
				CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset_cancelBatch(impl_POA_GDA_Recordset * servant,
				CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset_cancelUpdate(impl_POA_GDA_Recordset * servant,
				 CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset_close(impl_POA_GDA_Recordset * servant,
			  CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset_deleteCurrent(impl_POA_GDA_Recordset * servant,
				  CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset_move(impl_POA_GDA_Recordset * servant,
			 CORBA_long count,
			 CORBA_long bookmark,
			 CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset_moveFirst(impl_POA_GDA_Recordset * servant,
			      CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset_moveLast(impl_POA_GDA_Recordset * servant,
			     CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset_reQuery(impl_POA_GDA_Recordset * servant,
			    CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset_reSync(impl_POA_GDA_Recordset * servant,
			   CORBA_Environment * ev);

static CORBA_boolean
 impl_GDA_Recordset_supports(impl_POA_GDA_Recordset * servant,
			     GDA_Option what,
			     CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset_update(impl_POA_GDA_Recordset * servant,
			   CORBA_Environment * ev);

static CORBA_long
 impl_GDA_Recordset_updateBatch(impl_POA_GDA_Recordset * servant,
				CORBA_Environment * ev);

static GDA_Recordset_Chunk *
 impl_GDA_Recordset_fetch(impl_POA_GDA_Recordset * servant,
			  CORBA_long count,
			  CORBA_Environment * ev);

static GDA_RowAttributes *
 impl_GDA_Recordset_describe(impl_POA_GDA_Recordset * servant,
			     CORBA_Environment * ev);

static void impl_GDA_ConnectionFactory__destroy(impl_POA_GDA_ConnectionFactory * servant,
						CORBA_Environment * ev);
static CORBA_Object
 impl_GDA_ConnectionFactory_create_connection(impl_POA_GDA_ConnectionFactory * servant,
					      CORBA_char * goad_id,
					      CORBA_Environment * ev);

static CORBA_boolean
 impl_GDA_ConnectionFactory_supports(impl_POA_GDA_ConnectionFactory * servant,
				     CORBA_char * obj_goad_id,
				     CORBA_Environment * ev);
static CORBA_Object
 impl_GDA_ConnectionFactory_create_object(impl_POA_GDA_ConnectionFactory * servant,
					  CORBA_char * goad_id,
					  GNOME_stringlist * params,
					  CORBA_Environment * ev);

/*** epv structures ***/

static PortableServer_ServantBase__epv impl_GNOME_GenericFactory_base_epv =
{
   NULL,			/* _private data */
   NULL,			/* finalize routine */
   NULL,			/* default_POA routine */
};
static POA_GNOME_GenericFactory__epv impl_GNOME_GenericFactory_epv =
{
   NULL,			/* _private */

   (gpointer) & impl_GNOME_GenericFactory_supports,

   (gpointer) & impl_GNOME_GenericFactory_create_object,

};

static PortableServer_ServantBase__epv impl_GDA_Fieldx_base_epv =
{
   NULL,			/* _private data */
   NULL,			/* finalize routine */
   NULL,			/* default_POA routine */
};
static POA_GDA_Fieldx__epv impl_GDA_Fieldx_epv =
{
   NULL,			/* _private */
   (gpointer) & impl_GDA_Fieldx_appendChunk,

   (gpointer) & impl_GDA_Fieldx_getChunk,

};

static PortableServer_ServantBase__epv impl_GDA_Parameter_base_epv =
{
   NULL,			/* _private data */
   NULL,			/* finalize routine */
   NULL,			/* default_POA routine */
};
static POA_GDA_Parameter__epv impl_GDA_Parameter_epv =
{
   NULL,			/* _private */

   (gpointer) & impl_GDA_Parameter_appendChunk,

};

static PortableServer_ServantBase__epv impl_GDA_Command_base_epv =
{
   NULL,			/* _private data */
   NULL,			/* finalize routine */
   NULL,			/* default_POA routine */
};
static POA_GDA_Command__epv impl_GDA_Command_epv =
{
   NULL,			/* _private */
   (gpointer) & impl_GDA_Command__get_cmdTimeout,
   (gpointer) & impl_GDA_Command__set_cmdTimeout,

   (gpointer) & impl_GDA_Command__get_prepared,

   (gpointer) & impl_GDA_Command__get_state,
   (gpointer) & impl_GDA_Command__set_state,

   (gpointer) & impl_GDA_Command__get_text,
   (gpointer) & impl_GDA_Command__set_text,

   (gpointer) & impl_GDA_Command__get_type,
   (gpointer) & impl_GDA_Command__set_type,

   (gpointer) & impl_GDA_Command_open,

};
static PortableServer_ServantBase__epv impl_GDA_Connection_base_epv =
{
   NULL,			/* _private data */
   NULL,			/* finalize routine */
   NULL,			/* default_POA routine */
};
static POA_GDA_Connection__epv impl_GDA_Connection_epv =
{
   NULL,			/* _private */

   (gpointer) & impl_GDA_Connection__get_flags,
   (gpointer) & impl_GDA_Connection__set_flags,

   (gpointer) & impl_GDA_Connection__get_cmdTimeout,
   (gpointer) & impl_GDA_Connection__set_cmdTimeout,

   (gpointer) & impl_GDA_Connection__get_connectTimeout,
   (gpointer) & impl_GDA_Connection__set_connectTimeout,

   (gpointer) & impl_GDA_Connection__get_cursor,
   (gpointer) & impl_GDA_Connection__set_cursor,

   (gpointer) & impl_GDA_Connection__get_version,

   (gpointer) & impl_GDA_Connection__get_errors,

   (gpointer) & impl_GDA_Connection_beginTransaction,

   (gpointer) & impl_GDA_Connection_commitTransaction,

   (gpointer) & impl_GDA_Connection_rollbackTransaction,

   (gpointer) & impl_GDA_Connection_close,

   (gpointer) & impl_GDA_Connection_open,

   (gpointer) & impl_GDA_Connection_openSchema,

   (gpointer) & impl_GDA_Connection_createCommand,

   (gpointer) & impl_GDA_Connection_createRecordset,

   (gpointer) & impl_GDA_Connection_listSources,

   (gpointer) & impl_GDA_Connection_startLogging,

   (gpointer) & impl_GDA_Connection_stopLogging,

   (gpointer) & impl_GDA_Connection_createTable,

};

static PortableServer_ServantBase__epv impl_GDA_Recordset_base_epv =
{
   NULL,			/* _private data */
   NULL,			/* finalize routine */
   NULL,			/* default_POA routine */
};
static POA_GDA_Recordset__epv impl_GDA_Recordset_epv =
{
   NULL,			/* _private */

   (gpointer) & impl_GDA_Recordset__get_currentBookmark,
   (gpointer) & impl_GDA_Recordset__set_currentBookmark,

   (gpointer) & impl_GDA_Recordset__get_cachesize,
   (gpointer) & impl_GDA_Recordset__set_cachesize,

   (gpointer) & impl_GDA_Recordset__get_currentCursorType,
   (gpointer) & impl_GDA_Recordset__set_currentCursorType,

   (gpointer) & impl_GDA_Recordset__get_lockingMode,
   (gpointer) & impl_GDA_Recordset__set_lockingMode,

   (gpointer) & impl_GDA_Recordset__get_maxrecords,
   (gpointer) & impl_GDA_Recordset__set_maxrecords,

   (gpointer) & impl_GDA_Recordset__get_pagecount,

   (gpointer) & impl_GDA_Recordset__get_pagesize,
   (gpointer) & impl_GDA_Recordset__set_pagesize,

   (gpointer) & impl_GDA_Recordset__get_recCount,

   (gpointer) & impl_GDA_Recordset__get_source,

   (gpointer) & impl_GDA_Recordset__get_status,

   (gpointer) & impl_GDA_Recordset_cancelBatch,

   (gpointer) & impl_GDA_Recordset_cancelUpdate,

   (gpointer) & impl_GDA_Recordset_close,

   (gpointer) & impl_GDA_Recordset_deleteCurrent,

   (gpointer) & impl_GDA_Recordset_move,

   (gpointer) & impl_GDA_Recordset_moveFirst,

   (gpointer) & impl_GDA_Recordset_moveLast,

   (gpointer) & impl_GDA_Recordset_reQuery,

   (gpointer) & impl_GDA_Recordset_reSync,

   (gpointer) & impl_GDA_Recordset_supports,

   (gpointer) & impl_GDA_Recordset_update,

   (gpointer) & impl_GDA_Recordset_updateBatch,

   (gpointer) & impl_GDA_Recordset_fetch,

   (gpointer) & impl_GDA_Recordset_describe,

};
static PortableServer_ServantBase__epv impl_GDA_ConnectionFactory_base_epv =
{
   NULL,			/* _private data */
   NULL,			/* finalize routine */
   NULL,			/* default_POA routine */
};
static POA_GDA_ConnectionFactory__epv impl_GDA_ConnectionFactory_epv =
{
   NULL,			/* _private */
   (gpointer) & impl_GDA_ConnectionFactory_create_connection,

};
static POA_GNOME_GenericFactory__epv impl_GDA_ConnectionFactory_GNOME_GenericFactory_epv =
{
   NULL,			/* _private */
   (gpointer) & impl_GDA_ConnectionFactory_supports,
   (gpointer) & impl_GDA_ConnectionFactory_create_object,
};

/*** vepv structures ***/

static POA_GNOME_GenericFactory__vepv impl_GNOME_GenericFactory_vepv =
{
   &impl_GNOME_GenericFactory_base_epv,
   &impl_GNOME_GenericFactory_epv,
};

static POA_GDA_Fieldx__vepv impl_GDA_Fieldx_vepv =
{
   &impl_GDA_Fieldx_base_epv,
   &impl_GDA_Fieldx_epv,
};

static POA_GDA_Parameter__vepv impl_GDA_Parameter_vepv =
{
   &impl_GDA_Parameter_base_epv,
   &impl_GDA_Parameter_epv,
};

static POA_GDA_Command__vepv impl_GDA_Command_vepv =
{
   &impl_GDA_Command_base_epv,
   &impl_GDA_Command_epv,
};
static POA_GDA_Connection__vepv impl_GDA_Connection_vepv =
{
   &impl_GDA_Connection_base_epv,
   &impl_GDA_Connection_epv,
};

static POA_GDA_Recordset__vepv impl_GDA_Recordset_vepv =
{
   &impl_GDA_Recordset_base_epv,
   &impl_GDA_Recordset_epv,
};
static POA_GDA_ConnectionFactory__vepv impl_GDA_ConnectionFactory_vepv =
{
   &impl_GDA_ConnectionFactory_base_epv,
   &impl_GDA_ConnectionFactory_GNOME_GenericFactory_epv,
   &impl_GDA_ConnectionFactory_epv,
};

/*** Stub implementations ***/

static GNOME_GenericFactory 
impl_GNOME_GenericFactory__create(PortableServer_POA poa, CORBA_Environment * ev)
{
   GNOME_GenericFactory retval;
   impl_POA_GNOME_GenericFactory *newservant;
   PortableServer_ObjectId *objid;

   newservant = g_new0(impl_POA_GNOME_GenericFactory, 1);
   newservant->servant.vepv = &impl_GNOME_GenericFactory_vepv;
   newservant->poa = poa;
   POA_GNOME_GenericFactory__init((PortableServer_Servant) newservant, ev);
   objid = PortableServer_POA_activate_object(poa, newservant, ev);
   CORBA_free(objid);
   retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

   return retval;
}

static void
impl_GNOME_GenericFactory__destroy(impl_POA_GNOME_GenericFactory * servant, CORBA_Environment * ev)
{
   PortableServer_ObjectId *objid;

   objid = PortableServer_POA_servant_to_id(servant->poa, servant, ev);
   PortableServer_POA_deactivate_object(servant->poa, objid, ev);
   CORBA_free(objid);

   POA_GNOME_GenericFactory__fini((PortableServer_Servant) servant, ev);
   g_free(servant);
}

static CORBA_boolean
impl_GNOME_GenericFactory_supports(impl_POA_GNOME_GenericFactory * servant,
				   CORBA_char * obj_goad_id,
				   CORBA_Environment * ev)
{
   CORBA_boolean retval;

   return retval;
}

static CORBA_Object
impl_GNOME_GenericFactory_create_object(impl_POA_GNOME_GenericFactory * servant,
					CORBA_char * goad_id,
					GNOME_stringlist * params,
					CORBA_Environment * ev)
{
   CORBA_Object retval;

   return retval;
}

static GDA_Fieldx 
impl_GDA_Fieldx__create(PortableServer_POA poa, CORBA_Environment * ev)
{
   GDA_Fieldx retval;
   impl_POA_GDA_Fieldx *newservant;
   PortableServer_ObjectId *objid;

   newservant = g_new0(impl_POA_GDA_Fieldx, 1);
   newservant->servant.vepv = &impl_GDA_Fieldx_vepv;
   newservant->poa = poa;
   POA_GDA_Fieldx__init((PortableServer_Servant) newservant, ev);
   objid = PortableServer_POA_activate_object(poa, newservant, ev);
   CORBA_free(objid);
   retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

   return retval;
}

static void
impl_GDA_Fieldx__destroy(impl_POA_GDA_Fieldx * servant, CORBA_Environment * ev)
{
   PortableServer_ObjectId *objid;

   objid = PortableServer_POA_servant_to_id(servant->poa, servant, ev);
   PortableServer_POA_deactivate_object(servant->poa, objid, ev);
   CORBA_free(objid);

   POA_GDA_Fieldx__fini((PortableServer_Servant) servant, ev);
   g_free(servant);
}

static CORBA_long
impl_GDA_Fieldx_appendChunk(impl_POA_GDA_Fieldx * servant,
			    GDA_VarBinString * data,
			    CORBA_Environment * ev)
{
   CORBA_long retval;

   return retval;
}

static GDA_VarBinString *
impl_GDA_Fieldx_getChunk(impl_POA_GDA_Fieldx * servant,
			 CORBA_long amount,
			 CORBA_Environment * ev)
{
   GDA_VarBinString *retval;
   retval  = 0;
   return retval;
}

static GDA_Parameter 
impl_GDA_Parameter__create(PortableServer_POA poa, CORBA_Environment * ev)
{
   GDA_Parameter retval;
   impl_POA_GDA_Parameter *newservant;
   PortableServer_ObjectId *objid;

   newservant = g_new0(impl_POA_GDA_Parameter, 1);
   newservant->servant.vepv = &impl_GDA_Parameter_vepv;
   newservant->poa = poa;
   POA_GDA_Parameter__init((PortableServer_Servant) newservant, ev);
   objid = PortableServer_POA_activate_object(poa, newservant, ev);
   CORBA_free(objid);
   retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

   return retval;
}

static void
impl_GDA_Parameter__destroy(impl_POA_GDA_Parameter * servant, CORBA_Environment * ev)
{
   PortableServer_ObjectId *objid;

   objid = PortableServer_POA_servant_to_id(servant->poa, servant, ev);
   PortableServer_POA_deactivate_object(servant->poa, objid, ev);
   CORBA_free(objid);

   POA_GDA_Parameter__fini((PortableServer_Servant) servant, ev);
   g_free(servant);
}

static CORBA_long
impl_GDA_Parameter_appendChunk(impl_POA_GDA_Parameter * servant,
			       GDA_Parameter_VarBinString * data,
			       CORBA_Environment * ev)
{
   CORBA_long retval;
   retval = -1;
   return retval;
}

static GDA_Command 
impl_GDA_Command__create(PortableServer_POA poa, CORBA_Environment * ev)
{
   GDA_Command retval;
   impl_POA_GDA_Command *newservant;
   PortableServer_ObjectId *objid;

   newservant = g_new0(impl_POA_GDA_Command, 1);
   newservant->servant.vepv = &impl_GDA_Command_vepv;
   newservant->poa = poa;
   POA_GDA_Command__init((PortableServer_Servant) newservant, ev);
   objid = PortableServer_POA_activate_object(poa, newservant, ev);
   CORBA_free(objid);
   retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

   return retval;
}

static void
impl_GDA_Command__destroy(impl_POA_GDA_Command * servant, CORBA_Environment * ev)
{
   PortableServer_ObjectId *objid;

   objid = PortableServer_POA_servant_to_id(servant->poa, servant, ev);
   PortableServer_POA_deactivate_object(servant->poa, objid, ev);
   CORBA_free(objid);

   POA_GDA_Command__fini((PortableServer_Servant) servant, ev);
   g_free(servant);
}

static CORBA_long
impl_GDA_Command__get_cmdTimeout(impl_POA_GDA_Command * servant,
				 CORBA_Environment * ev)
{
   CORBA_long retval;
   retval = 0;
   return retval;
}

static void
impl_GDA_Command__set_cmdTimeout(impl_POA_GDA_Command * servant,
				 CORBA_long value,
				 CORBA_Environment * ev)
{
}

static CORBA_boolean
impl_GDA_Command__get_prepared(impl_POA_GDA_Command * servant,
			       CORBA_Environment * ev)
{
   CORBA_boolean retval;
   retval = FALSE;
   return retval;
}

static CORBA_long
impl_GDA_Command__get_state(impl_POA_GDA_Command * servant,
			    CORBA_Environment * ev)
{
   CORBA_long retval;
   retval= 0;
   return retval;
}

static void
impl_GDA_Command__set_state(impl_POA_GDA_Command * servant,
			    CORBA_long value,
			    CORBA_Environment * ev)
{
}

static CORBA_char *
impl_GDA_Command__get_text(impl_POA_GDA_Command * servant,
			   CORBA_Environment * ev)
{
   CORBA_char *retval;

   return retval;
}

static void
impl_GDA_Command__set_text(impl_POA_GDA_Command * servant,
			   CORBA_char * value,
			   CORBA_Environment * ev)
{
}

static CORBA_unsigned_long
impl_GDA_Command__get_type(impl_POA_GDA_Command * servant,
			   CORBA_Environment * ev)
{
   CORBA_unsigned_long retval;

   return retval;
}

static void
impl_GDA_Command__set_type(impl_POA_GDA_Command * servant,
			   CORBA_unsigned_long value,
			   CORBA_Environment * ev)
{
}

static GDA_Recordset
impl_GDA_Command_open(impl_POA_GDA_Command * servant,
		      GDA_CmdParameterSeq * param,
		      GDA_CursorType ct,
		      GDA_LockType lt,
		      CORBA_unsigned_long * affected,
		      CORBA_Environment * ev)
{
   GDA_Recordset retval;

   return retval;
}

static GDA_Connection 
impl_GDA_Connection__create(PortableServer_POA poa, CORBA_Environment * ev)
{
   GDA_Connection retval;
   impl_POA_GDA_Connection *newservant;
   PortableServer_ObjectId *objid;

   newservant = g_new0(impl_POA_GDA_Connection, 1);
   newservant->servant.vepv = &impl_GDA_Connection_vepv;
   newservant->poa = poa;
   POA_GDA_Connection__init((PortableServer_Servant) newservant, ev);
   objid = PortableServer_POA_activate_object(poa, newservant, ev);
   CORBA_free(objid);
   retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

   return retval;
}

static void
impl_GDA_Connection__destroy(impl_POA_GDA_Connection * servant, CORBA_Environment * ev)
{
   PortableServer_ObjectId *objid;

   objid = PortableServer_POA_servant_to_id(servant->poa, servant, ev);
   PortableServer_POA_deactivate_object(servant->poa, objid, ev);
   CORBA_free(objid);

   POA_GDA_Connection__fini((PortableServer_Servant) servant, ev);
   g_free(servant);
}

static CORBA_long
impl_GDA_Connection__get_flags(impl_POA_GDA_Connection * servant,
			       CORBA_Environment * ev)
{
   CORBA_long retval;
   retval = 0;
   return retval;
}

static void
impl_GDA_Connection__set_flags(impl_POA_GDA_Connection * servant,
			       CORBA_long value,
			       CORBA_Environment * ev)
{
}

static CORBA_long
impl_GDA_Connection__get_cmdTimeout(impl_POA_GDA_Connection * servant,
				    CORBA_Environment * ev)
{
   CORBA_long retval;

   return retval;
}

static void
impl_GDA_Connection__set_cmdTimeout(impl_POA_GDA_Connection * servant,
				    CORBA_long value,
				    CORBA_Environment * ev)
{
}

static CORBA_long
impl_GDA_Connection__get_connectTimeout(impl_POA_GDA_Connection * servant,
					CORBA_Environment * ev)
{
   CORBA_long retval;

   return retval;
}

static void
impl_GDA_Connection__set_connectTimeout(impl_POA_GDA_Connection * servant,
					CORBA_long value,
					CORBA_Environment * ev)
{
}

static GDA_CursorLocation
impl_GDA_Connection__get_cursor(impl_POA_GDA_Connection * servant,
				CORBA_Environment * ev)
{
   GDA_CursorLocation retval;

   return retval;
}

static void
impl_GDA_Connection__set_cursor(impl_POA_GDA_Connection * servant,
				GDA_CursorLocation value,
				CORBA_Environment * ev)
{
}

static CORBA_char *
impl_GDA_Connection__get_version(impl_POA_GDA_Connection * servant,
				 CORBA_Environment * ev)
{
   CORBA_char *retval;

   return retval;
}

static GDA_ErrorSeq *
impl_GDA_Connection__get_errors(impl_POA_GDA_Connection * servant,
				CORBA_Environment * ev)
{
   GDA_ErrorSeq *retval;

   return retval;
}

static CORBA_long
impl_GDA_Connection_beginTransaction(impl_POA_GDA_Connection * servant,
				     CORBA_Environment * ev)
{
   CORBA_long retval;

   return retval;
}

static CORBA_long
impl_GDA_Connection_commitTransaction(impl_POA_GDA_Connection * servant,
				      CORBA_Environment * ev)
{
   CORBA_long retval;

   return retval;
}

static CORBA_long
impl_GDA_Connection_rollbackTransaction(impl_POA_GDA_Connection * servant,
					CORBA_Environment * ev)
{
   CORBA_long retval;

   return retval;
}

static CORBA_long
impl_GDA_Connection_close(impl_POA_GDA_Connection * servant,
			  CORBA_Environment * ev)
{
   CORBA_long retval;

   return retval;
}

static CORBA_long
impl_GDA_Connection_open(impl_POA_GDA_Connection * servant,
			 CORBA_char * dsn,
			 CORBA_char * user,
			 CORBA_char * passwd,
			 CORBA_Environment * ev)
{
  g_print("%s: called\n", __PRETTY_FUNCTION__);
  servant->cnc = gda_sybase_connection_open(dsn, user, passwd);
  if (servant->cnc)
    return 0;
  return -1;
}

static GDA_Recordset
impl_GDA_Connection_openSchema(impl_POA_GDA_Connection * servant,
			       GDA_Connection_QType t,
			       GDA_Connection_ConstraintSeq * constraints,
			       CORBA_Environment * ev)
{
   GDA_Recordset retval;

   return retval;
}

static GDA_Command
impl_GDA_Connection_createCommand(impl_POA_GDA_Connection * servant,
				  CORBA_Environment * ev)
{
   GDA_Command retval;

   return retval;
}

static GDA_Recordset
impl_GDA_Connection_createRecordset(impl_POA_GDA_Connection * servant,
				    CORBA_Environment * ev)
{
   GDA_Recordset retval;

   return retval;
}

static GDA_Connection_DSNlist *
impl_GDA_Connection_listSources(impl_POA_GDA_Connection * servant,
				CORBA_Environment * ev)
{
   GDA_Connection_DSNlist *retval;

   return retval;
}

static CORBA_long
impl_GDA_Connection_startLogging(impl_POA_GDA_Connection * servant,
				 CORBA_char * filename,
				 CORBA_Environment * ev)
{
   CORBA_long retval;

   return retval;
}

static CORBA_long
impl_GDA_Connection_stopLogging(impl_POA_GDA_Connection * servant,
				CORBA_Environment * ev)
{
   CORBA_long retval;

   return retval;
}

static CORBA_char *
impl_GDA_Connection_createTable(impl_POA_GDA_Connection * servant,
				CORBA_char * name,
				GDA_RowAttributes * columns,
				CORBA_Environment * ev)
{
   CORBA_char *retval;

   return retval;
}

static GDA_Recordset 
impl_GDA_Recordset__create(PortableServer_POA poa, CORBA_Environment * ev)
{
   GDA_Recordset retval;
   impl_POA_GDA_Recordset *newservant;
   PortableServer_ObjectId *objid;

   newservant = g_new0(impl_POA_GDA_Recordset, 1);
   newservant->servant.vepv = &impl_GDA_Recordset_vepv;
   newservant->poa = poa;
   POA_GDA_Recordset__init((PortableServer_Servant) newservant, ev);
   objid = PortableServer_POA_activate_object(poa, newservant, ev);
   CORBA_free(objid);
   retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

   return retval;
}

static void
impl_GDA_Recordset__destroy(impl_POA_GDA_Recordset * servant, CORBA_Environment * ev)
{
   PortableServer_ObjectId *objid;

   objid = PortableServer_POA_servant_to_id(servant->poa, servant, ev);
   PortableServer_POA_deactivate_object(servant->poa, objid, ev);
   CORBA_free(objid);

   POA_GDA_Recordset__fini((PortableServer_Servant) servant, ev);
   g_free(servant);
}

static CORBA_long
impl_GDA_Recordset__get_currentBookmark(impl_POA_GDA_Recordset * servant,
					CORBA_Environment * ev)
{
   CORBA_long retval;

   return retval;
}

static void
impl_GDA_Recordset__set_currentBookmark(impl_POA_GDA_Recordset * servant,
					CORBA_long value,
					CORBA_Environment * ev)
{
}

static CORBA_long
impl_GDA_Recordset__get_cachesize(impl_POA_GDA_Recordset * servant,
				  CORBA_Environment * ev)
{
   CORBA_long retval;

   return retval;
}

static void
impl_GDA_Recordset__set_cachesize(impl_POA_GDA_Recordset * servant,
				  CORBA_long value,
				  CORBA_Environment * ev)
{
}

static GDA_CursorType
impl_GDA_Recordset__get_currentCursorType(impl_POA_GDA_Recordset * servant,
					  CORBA_Environment * ev)
{
   GDA_CursorType retval;

   return retval;
}

static void
impl_GDA_Recordset__set_currentCursorType(impl_POA_GDA_Recordset * servant,
					  GDA_CursorType value,
					  CORBA_Environment * ev)
{
}

static GDA_LockType
impl_GDA_Recordset__get_lockingMode(impl_POA_GDA_Recordset * servant,
				    CORBA_Environment * ev)
{
   GDA_LockType retval;

   return retval;
}

static void
impl_GDA_Recordset__set_lockingMode(impl_POA_GDA_Recordset * servant,
				    GDA_LockType value,
				    CORBA_Environment * ev)
{
}

static CORBA_long
impl_GDA_Recordset__get_maxrecords(impl_POA_GDA_Recordset * servant,
				   CORBA_Environment * ev)
{
   CORBA_long retval;

   return retval;
}

static void
impl_GDA_Recordset__set_maxrecords(impl_POA_GDA_Recordset * servant,
				   CORBA_long value,
				   CORBA_Environment * ev)
{
}

static CORBA_long
impl_GDA_Recordset__get_pagecount(impl_POA_GDA_Recordset * servant,
				  CORBA_Environment * ev)
{
   CORBA_long retval;

   return retval;
}

static CORBA_long
impl_GDA_Recordset__get_pagesize(impl_POA_GDA_Recordset * servant,
				 CORBA_Environment * ev)
{
   CORBA_long retval;

   return retval;
}

static void
impl_GDA_Recordset__set_pagesize(impl_POA_GDA_Recordset * servant,
				 CORBA_long value,
				 CORBA_Environment * ev)
{
}

static CORBA_long
impl_GDA_Recordset__get_recCount(impl_POA_GDA_Recordset * servant,
				 CORBA_Environment * ev)
{
   CORBA_long retval;

   return retval;
}

static CORBA_char *
impl_GDA_Recordset__get_source(impl_POA_GDA_Recordset * servant,
			       CORBA_Environment * ev)
{
   CORBA_char *retval;

   return retval;
}

static CORBA_long
impl_GDA_Recordset__get_status(impl_POA_GDA_Recordset * servant,
			       CORBA_Environment * ev)
{
   CORBA_long retval;

   return retval;
}

static CORBA_long
impl_GDA_Recordset_cancelBatch(impl_POA_GDA_Recordset * servant,
			       CORBA_Environment * ev)
{
   CORBA_long retval;

   return retval;
}

static CORBA_long
impl_GDA_Recordset_cancelUpdate(impl_POA_GDA_Recordset * servant,
				CORBA_Environment * ev)
{
   CORBA_long retval;

   return retval;
}

static CORBA_long
impl_GDA_Recordset_close(impl_POA_GDA_Recordset * servant,
			 CORBA_Environment * ev)
{
   CORBA_long retval;

   return retval;
}

static CORBA_long
impl_GDA_Recordset_deleteCurrent(impl_POA_GDA_Recordset * servant,
				 CORBA_Environment * ev)
{
   CORBA_long retval;

   return retval;
}

static CORBA_long
impl_GDA_Recordset_move(impl_POA_GDA_Recordset * servant,
			CORBA_long count,
			CORBA_long bookmark,
			CORBA_Environment * ev)
{
   CORBA_long retval;

   return retval;
}

static CORBA_long
impl_GDA_Recordset_moveFirst(impl_POA_GDA_Recordset * servant,
			     CORBA_Environment * ev)
{
   CORBA_long retval;

   return retval;
}

static CORBA_long
impl_GDA_Recordset_moveLast(impl_POA_GDA_Recordset * servant,
			    CORBA_Environment * ev)
{
   CORBA_long retval;

   return retval;
}

static CORBA_long
impl_GDA_Recordset_reQuery(impl_POA_GDA_Recordset * servant,
			   CORBA_Environment * ev)
{
   CORBA_long retval;

   return retval;
}

static CORBA_long
impl_GDA_Recordset_reSync(impl_POA_GDA_Recordset * servant,
			  CORBA_Environment * ev)
{
   CORBA_long retval;

   return retval;
}

static CORBA_boolean
impl_GDA_Recordset_supports(impl_POA_GDA_Recordset * servant,
			    GDA_Option what,
			    CORBA_Environment * ev)
{
   CORBA_boolean retval;

   return retval;
}

static CORBA_long
impl_GDA_Recordset_update(impl_POA_GDA_Recordset * servant,
			  CORBA_Environment * ev)
{
   CORBA_long retval;

   return retval;
}

static CORBA_long
impl_GDA_Recordset_updateBatch(impl_POA_GDA_Recordset * servant,
			       CORBA_Environment * ev)
{
   CORBA_long retval;

   return retval;
}

static GDA_Recordset_Chunk *
impl_GDA_Recordset_fetch(impl_POA_GDA_Recordset * servant,
			 CORBA_long count,
			 CORBA_Environment * ev)
{
   GDA_Recordset_Chunk *retval;

   return retval;
}

static GDA_RowAttributes *
impl_GDA_Recordset_describe(impl_POA_GDA_Recordset * servant,
			    CORBA_Environment * ev)
{
   GDA_RowAttributes *retval;

   return retval;
}

GDA_ConnectionFactory 
impl_GDA_ConnectionFactory__create(PortableServer_POA poa, CORBA_Environment * ev)
{
   GDA_ConnectionFactory retval;
   impl_POA_GDA_ConnectionFactory *newservant;
   PortableServer_ObjectId *objid;

   newservant = g_new0(impl_POA_GDA_ConnectionFactory, 1);
   newservant->servant.vepv = &impl_GDA_ConnectionFactory_vepv;
   newservant->poa = poa;
   POA_GDA_ConnectionFactory__init((PortableServer_Servant) newservant, ev);
   objid = PortableServer_POA_activate_object(poa, newservant, ev);
   CORBA_free(objid);
   retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

   return retval;
}

static void
impl_GDA_ConnectionFactory__destroy(impl_POA_GDA_ConnectionFactory * servant, CORBA_Environment * ev)
{
   PortableServer_ObjectId *objid;

   objid = PortableServer_POA_servant_to_id(servant->poa, servant, ev);
   PortableServer_POA_deactivate_object(servant->poa, objid, ev);
   CORBA_free(objid);

   POA_GDA_ConnectionFactory__fini((PortableServer_Servant) servant, ev);
   g_free(servant);
}

static CORBA_Object
impl_GDA_ConnectionFactory_create_connection(impl_POA_GDA_ConnectionFactory * servant,
					     CORBA_char * goad_id,
					     CORBA_Environment * ev)
{
   CORBA_Object retval;
   retval = impl_GDA_Connection__create(servant->poa, ev);
   if (Exception(ev))
     {
       g_warning("%s cannot create connection object", __PRETTY_FUNCTION__);
       return CORBA_OBJECT_NIL;
     }
   return retval;
}

static CORBA_boolean
impl_GDA_ConnectionFactory_supports(impl_POA_GDA_ConnectionFactory * servant,
				    CORBA_char * obj_goad_id,
				    CORBA_Environment * ev)
{
   CORBA_boolean retval;

   return retval;
}

static CORBA_Object
impl_GDA_ConnectionFactory_create_object(impl_POA_GDA_ConnectionFactory * servant,
					 CORBA_char * goad_id,
					 GNOME_stringlist * params,
					 CORBA_Environment * ev)
{
   CORBA_Object retval;

   return retval;
}



