/* GNOME-DB
 * Copyright (c) 1998 by Rodrigo Moya
 * Copyright (C) 1999 Stephan Heinze
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gda-oracle-types.h"
#include "gda-oracle-field.h"
gchar* gda_stringify_value(gchar*, gint, Gda_ORACLE_Field*);

Gda_ORACLE_Field *
gda_oracle_field_new (void)
{
  Gda_ORACLE_Field* field;
  field = g_new0(Gda_ORACLE_Field, 1);
  return (field);
}

void
gda_oracle_field_free (Gda_ORACLE_Field *field)
{
  if (field->real_value)
    {
      g_free(field->real_value);
    }
  g_free(field);
}

void 
gda_oracle_field_dump (Gda_ORACLE_Field *field)
{
  g_print("---- field-dump - start ---- \n");
  g_print("name: %s\n", field->name);
  g_print("defined_length: %ld\n", field->defined_length);
  g_print("actual_length: %ld\n", field->actual_length);
  g_print("type: %d\n", field->value->_d ); 
  if( -2 == field->indicator )
    g_print("value is NULL");
  g_print("---- field-dump - end ---- \n");
}
